@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.JobAgentArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure SQL job agent.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a job agent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobAgent = new AzureNative.Sql.JobAgent("jobAgent", new()
 *     {
 *         DatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/databases/db1",
 *         JobAgentName = "agent1",
 *         Location = "southeastasia",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobAgent(ctx, "jobAgent", &sql.JobAgentArgs{
 * 			DatabaseId:        pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/databases/db1"),
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobAgent;
 * import com.pulumi.azurenative.sql.JobAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobAgent = new JobAgent("jobAgent", JobAgentArgs.builder()
 *             .databaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/databases/db1")
 *             .jobAgentName("agent1")
 *             .location("southeastasia")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobAgent agent1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}
 * ```
 * @property databaseId Resource ID of the database to store job metadata in.
 * @property jobAgentName The name of the job agent to be created or updated.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property sku The name and tier of the SKU.
 * @property tags Resource tags.
 */
public data class JobAgentArgs(
    public val databaseId: Output<String>? = null,
    public val jobAgentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.JobAgentArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.JobAgentArgs =
        com.pulumi.azurenative.sql.JobAgentArgs.builder()
            .databaseId(databaseId?.applyValue({ args0 -> args0 }))
            .jobAgentName(jobAgentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [JobAgentArgs].
 */
@PulumiTagMarker
public class JobAgentArgsBuilder internal constructor() {
    private var databaseId: Output<String>? = null

    private var jobAgentName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource ID of the database to store job metadata in.
     */
    @JvmName("uyvfmebaoedbfpod")
    public suspend fun databaseId(`value`: Output<String>) {
        this.databaseId = value
    }

    /**
     * @param value The name of the job agent to be created or updated.
     */
    @JvmName("bwtgnhljslpqmrre")
    public suspend fun jobAgentName(`value`: Output<String>) {
        this.jobAgentName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("cvdyuvamhcgsedfh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hfrrenuwvmcqgybp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("nsedacnfljtxauqj")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name and tier of the SKU.
     */
    @JvmName("dyhkdphdecsnvome")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pbwveebxaxoaifrt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource ID of the database to store job metadata in.
     */
    @JvmName("bfxjqvvuiywcdymk")
    public suspend fun databaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseId = mapped
    }

    /**
     * @param value The name of the job agent to be created or updated.
     */
    @JvmName("ijcmwxagqaymbalj")
    public suspend fun jobAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobAgentName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vugojtykiutmfvmt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vthhasdavnllgrfu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("kqqmpcbqvgqnukdq")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name and tier of the SKU.
     */
    @JvmName("vbcnimcqgbdpnokw")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The name and tier of the SKU.
     */
    @JvmName("ugsxkrggfslnxtwy")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gqufwripyhorhert")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("drhwskamvkgpmboi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): JobAgentArgs = JobAgentArgs(
        databaseId = databaseId,
        jobAgentName = jobAgentName,
        location = location,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        sku = sku,
        tags = tags,
    )
}
