@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedDatabaseSensitivityLabelArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.SensitivityLabelRank
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A sensitivity label.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Updates or creates a sensitivity label of a given column with all parameters in a managed database
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabaseSensitivityLabel = new AzureNative.Sql.ManagedDatabaseSensitivityLabel("managedDatabaseSensitivityLabel", new()
 *     {
 *         ColumnName = "myColumn",
 *         DatabaseName = "myDatabase",
 *         InformationType = "PhoneNumber",
 *         InformationTypeId = "d22fa6e9-5ee4-3bde-4c2b-a409604c4646",
 *         LabelId = "bf91e08c-f4f0-478a-b016-25164b2a65ff",
 *         LabelName = "PII",
 *         ManagedInstanceName = "myManagedInstanceName",
 *         Rank = AzureNative.Sql.SensitivityLabelRank.High,
 *         ResourceGroupName = "myRG",
 *         SchemaName = "dbo",
 *         SensitivityLabelSource = "current",
 *         TableName = "myTable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabaseSensitivityLabel(ctx, "managedDatabaseSensitivityLabel", &sql.ManagedDatabaseSensitivityLabelArgs{
 * 			ColumnName:             pulumi.String("myColumn"),
 * 			DatabaseName:           pulumi.String("myDatabase"),
 * 			InformationType:        pulumi.String("PhoneNumber"),
 * 			InformationTypeId:      pulumi.String("d22fa6e9-5ee4-3bde-4c2b-a409604c4646"),
 * 			LabelId:                pulumi.String("bf91e08c-f4f0-478a-b016-25164b2a65ff"),
 * 			LabelName:              pulumi.String("PII"),
 * 			ManagedInstanceName:    pulumi.String("myManagedInstanceName"),
 * 			Rank:                   sql.SensitivityLabelRankHigh,
 * 			ResourceGroupName:      pulumi.String("myRG"),
 * 			SchemaName:             pulumi.String("dbo"),
 * 			SensitivityLabelSource: pulumi.String("current"),
 * 			TableName:              pulumi.String("myTable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabaseSensitivityLabel;
 * import com.pulumi.azurenative.sql.ManagedDatabaseSensitivityLabelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabaseSensitivityLabel = new ManagedDatabaseSensitivityLabel("managedDatabaseSensitivityLabel", ManagedDatabaseSensitivityLabelArgs.builder()
 *             .columnName("myColumn")
 *             .databaseName("myDatabase")
 *             .informationType("PhoneNumber")
 *             .informationTypeId("d22fa6e9-5ee4-3bde-4c2b-a409604c4646")
 *             .labelId("bf91e08c-f4f0-478a-b016-25164b2a65ff")
 *             .labelName("PII")
 *             .managedInstanceName("myManagedInstanceName")
 *             .rank("High")
 *             .resourceGroupName("myRG")
 *             .schemaName("dbo")
 *             .sensitivityLabelSource("current")
 *             .tableName("myTable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedDatabaseSensitivityLabel current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}
 * ```
 * @property columnName The name of the column.
 * @property databaseName The name of the database.
 * @property informationType The information type.
 * @property informationTypeId The information type ID.
 * @property labelId The label ID.
 * @property labelName The label name.
 * @property managedInstanceName The name of the managed instance.
 * @property rank
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property schemaName The name of the schema.
 * @property sensitivityLabelSource The source of the sensitivity label.
 * @property tableName The name of the table.
 */
public data class ManagedDatabaseSensitivityLabelArgs(
    public val columnName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val informationType: Output<String>? = null,
    public val informationTypeId: Output<String>? = null,
    public val labelId: Output<String>? = null,
    public val labelName: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val rank: Output<SensitivityLabelRank>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val sensitivityLabelSource: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedDatabaseSensitivityLabelArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedDatabaseSensitivityLabelArgs =
        com.pulumi.azurenative.sql.ManagedDatabaseSensitivityLabelArgs.builder()
            .columnName(columnName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .informationType(informationType?.applyValue({ args0 -> args0 }))
            .informationTypeId(informationTypeId?.applyValue({ args0 -> args0 }))
            .labelId(labelId?.applyValue({ args0 -> args0 }))
            .labelName(labelName?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .rank(rank?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 }))
            .sensitivityLabelSource(sensitivityLabelSource?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedDatabaseSensitivityLabelArgs].
 */
@PulumiTagMarker
public class ManagedDatabaseSensitivityLabelArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var informationType: Output<String>? = null

    private var informationTypeId: Output<String>? = null

    private var labelId: Output<String>? = null

    private var labelName: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var rank: Output<SensitivityLabelRank>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var sensitivityLabelSource: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the column.
     */
    @JvmName("uhgwwrwtsixvauho")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("fdhjagrwymsirkmc")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The information type.
     */
    @JvmName("jtwsdflktoedgxnx")
    public suspend fun informationType(`value`: Output<String>) {
        this.informationType = value
    }

    /**
     * @param value The information type ID.
     */
    @JvmName("otwsuiblmkxieahp")
    public suspend fun informationTypeId(`value`: Output<String>) {
        this.informationTypeId = value
    }

    /**
     * @param value The label ID.
     */
    @JvmName("vheulgdoyyiwddsy")
    public suspend fun labelId(`value`: Output<String>) {
        this.labelId = value
    }

    /**
     * @param value The label name.
     */
    @JvmName("bqpxpefyqlmcrlyf")
    public suspend fun labelName(`value`: Output<String>) {
        this.labelName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("qyjmntxfroxnaklm")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value
     */
    @JvmName("gvnyxpgpbuvffiir")
    public suspend fun rank(`value`: Output<SensitivityLabelRank>) {
        this.rank = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nmwoqofypaotlgfi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the schema.
     */
    @JvmName("nyqhxmkaacsfndhi")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value The source of the sensitivity label.
     */
    @JvmName("xcrmuuoxppuetqbu")
    public suspend fun sensitivityLabelSource(`value`: Output<String>) {
        this.sensitivityLabelSource = value
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("twcdpuoobgxmbltm")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the column.
     */
    @JvmName("oytbsqvqgrspmaii")
    public suspend fun columnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("yevnnnjpdhiidvgb")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The information type.
     */
    @JvmName("ahghovywpmoeabcl")
    public suspend fun informationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.informationType = mapped
    }

    /**
     * @param value The information type ID.
     */
    @JvmName("rfejfvpcorhsfeko")
    public suspend fun informationTypeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.informationTypeId = mapped
    }

    /**
     * @param value The label ID.
     */
    @JvmName("cxwksovaeonhwlku")
    public suspend fun labelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelId = mapped
    }

    /**
     * @param value The label name.
     */
    @JvmName("fforrlwenceeefrk")
    public suspend fun labelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("cxqdswpjxvicsedl")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ukhphkuavtrgmxec")
    public suspend fun rank(`value`: SensitivityLabelRank?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rank = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ijaehkmnkicmrvpc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schema.
     */
    @JvmName("lrywjceemusvfekv")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value The source of the sensitivity label.
     */
    @JvmName("duxcmkyovbvnpgsw")
    public suspend fun sensitivityLabelSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sensitivityLabelSource = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("awadjammptuaaiqo")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): ManagedDatabaseSensitivityLabelArgs = ManagedDatabaseSensitivityLabelArgs(
        columnName = columnName,
        databaseName = databaseName,
        informationType = informationType,
        informationTypeId = informationTypeId,
        labelId = labelId,
        labelName = labelName,
        managedInstanceName = managedInstanceName,
        rank = rank,
        resourceGroupName = resourceGroupName,
        schemaName = schemaName,
        sensitivityLabelSource = sensitivityLabelSource,
        tableName = tableName,
    )
}
