@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedInstanceKeyArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ServerKeyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A managed instance key.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Creates or updates a managed instance key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstanceKey = new AzureNative.Sql.ManagedInstanceKey("managedInstanceKey", new()
 *     {
 *         KeyName = "someVault_someKey_01234567890123456789012345678901",
 *         ManagedInstanceName = "sqlcrudtest-4645",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerKeyType = "AzureKeyVault",
 *         Uri = "https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstanceKey(ctx, "managedInstanceKey", &sql.ManagedInstanceKeyArgs{
 * 			KeyName:             pulumi.String("someVault_someKey_01234567890123456789012345678901"),
 * 			ManagedInstanceName: pulumi.String("sqlcrudtest-4645"),
 * 			ResourceGroupName:   pulumi.String("sqlcrudtest-7398"),
 * 			ServerKeyType:       pulumi.String("AzureKeyVault"),
 * 			Uri:                 pulumi.String("https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstanceKey;
 * import com.pulumi.azurenative.sql.ManagedInstanceKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstanceKey = new ManagedInstanceKey("managedInstanceKey", ManagedInstanceKeyArgs.builder()
 *             .keyName("someVault_someKey_01234567890123456789012345678901")
 *             .managedInstanceName("sqlcrudtest-4645")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverKeyType("AzureKeyVault")
 *             .uri("https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstanceKey sqlcrudtest-4645 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}
 * ```
 * @property keyName The name of the managed instance key to be operated on (updated or created).
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverKeyType The key type like 'ServiceManaged', 'AzureKeyVault'.
 * @property uri The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
 */
public data class ManagedInstanceKeyArgs(
    public val keyName: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverKeyType: Output<Either<String, ServerKeyType>>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedInstanceKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedInstanceKeyArgs =
        com.pulumi.azurenative.sql.ManagedInstanceKeyArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverKeyType(
                serverKeyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstanceKeyArgs].
 */
@PulumiTagMarker
public class ManagedInstanceKeyArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverKeyType: Output<Either<String, ServerKeyType>>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The name of the managed instance key to be operated on (updated or created).
     */
    @JvmName("emuklnfsdaisejwc")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("ctjirfwdsgalplhn")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jvdbmdgsbbhiiljt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("bdosnlnyrglolbgk")
    public suspend fun serverKeyType(`value`: Output<Either<String, ServerKeyType>>) {
        this.serverKeyType = value
    }

    /**
     * @param value The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     */
    @JvmName("vbuptfhlwongpilc")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The name of the managed instance key to be operated on (updated or created).
     */
    @JvmName("ifwvydrqgvkhkagb")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("kxlyqibkiyvrocpu")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("aavbemhhoqwqrnxy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("kdbfueqfskomrhtu")
    public suspend fun serverKeyType(`value`: Either<String, ServerKeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("gvyfqkswfkdhyyrq")
    public fun serverKeyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("kwgxupwouygkovuj")
    public fun serverKeyType(`value`: ServerKeyType) {
        val toBeMapped = Either.ofRight<String, ServerKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     */
    @JvmName("txrywdrypucvrtph")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ManagedInstanceKeyArgs = ManagedInstanceKeyArgs(
        keyName = keyName,
        managedInstanceName = managedInstanceName,
        resourceGroupName = resourceGroupName,
        serverKeyType = serverKeyType,
        uri = uri,
    )
}
