@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A long term retention policy.
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update the LTR policy for the managed database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstanceLongTermRetentionPolicy = new AzureNative.Sql.ManagedInstanceLongTermRetentionPolicy("managedInstanceLongTermRetentionPolicy", new()
 *     {
 *         DatabaseName = "testDatabase",
 *         ManagedInstanceName = "testInstance",
 *         MonthlyRetention = "P1Y",
 *         PolicyName = "default",
 *         ResourceGroupName = "testResourceGroup",
 *         WeekOfYear = 5,
 *         WeeklyRetention = "P1M",
 *         YearlyRetention = "P5Y",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstanceLongTermRetentionPolicy(ctx, "managedInstanceLongTermRetentionPolicy", &sql.ManagedInstanceLongTermRetentionPolicyArgs{
 * 			DatabaseName:        pulumi.String("testDatabase"),
 * 			ManagedInstanceName: pulumi.String("testInstance"),
 * 			MonthlyRetention:    pulumi.String("P1Y"),
 * 			PolicyName:          pulumi.String("default"),
 * 			ResourceGroupName:   pulumi.String("testResourceGroup"),
 * 			WeekOfYear:          pulumi.Int(5),
 * 			WeeklyRetention:     pulumi.String("P1M"),
 * 			YearlyRetention:     pulumi.String("P5Y"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicy;
 * import com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstanceLongTermRetentionPolicy = new ManagedInstanceLongTermRetentionPolicy("managedInstanceLongTermRetentionPolicy", ManagedInstanceLongTermRetentionPolicyArgs.builder()
 *             .databaseName("testDatabase")
 *             .managedInstanceName("testInstance")
 *             .monthlyRetention("P1Y")
 *             .policyName("default")
 *             .resourceGroupName("testResourceGroup")
 *             .weekOfYear(5)
 *             .weeklyRetention("P1M")
 *             .yearlyRetention("P5Y")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstanceLongTermRetentionPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/backupLongTermRetentionPolicies/{policyName}
 * ```
 * @property databaseName The name of the database.
 * @property managedInstanceName The name of the managed instance.
 * @property monthlyRetention The monthly retention policy for an LTR backup in an ISO 8601 format.
 * @property policyName The policy name. Should always be Default.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property weekOfYear The week of year to take the yearly backup in an ISO 8601 format.
 * @property weeklyRetention The weekly retention policy for an LTR backup in an ISO 8601 format.
 * @property yearlyRetention The yearly retention policy for an LTR backup in an ISO 8601 format.
 */
public data class ManagedInstanceLongTermRetentionPolicyArgs(
    public val databaseName: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val monthlyRetention: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val weekOfYear: Output<Int>? = null,
    public val weeklyRetention: Output<String>? = null,
    public val yearlyRetention: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicyArgs =
        com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicyArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .monthlyRetention(monthlyRetention?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .weekOfYear(weekOfYear?.applyValue({ args0 -> args0 }))
            .weeklyRetention(weeklyRetention?.applyValue({ args0 -> args0 }))
            .yearlyRetention(yearlyRetention?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstanceLongTermRetentionPolicyArgs].
 */
@PulumiTagMarker
public class ManagedInstanceLongTermRetentionPolicyArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var monthlyRetention: Output<String>? = null

    private var policyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var weekOfYear: Output<Int>? = null

    private var weeklyRetention: Output<String>? = null

    private var yearlyRetention: Output<String>? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("nuaykbxxiaqlbpye")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("uerqrdcqbtqophyq")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The monthly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("sjgqyhgwrcawcjed")
    public suspend fun monthlyRetention(`value`: Output<String>) {
        this.monthlyRetention = value
    }

    /**
     * @param value The policy name. Should always be Default.
     */
    @JvmName("jwmstnpmyfcwwfha")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("yxcfoendumnikhwd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The week of year to take the yearly backup in an ISO 8601 format.
     */
    @JvmName("uubnlpwiuvdauetu")
    public suspend fun weekOfYear(`value`: Output<Int>) {
        this.weekOfYear = value
    }

    /**
     * @param value The weekly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("gragbghjyjvlqfau")
    public suspend fun weeklyRetention(`value`: Output<String>) {
        this.weeklyRetention = value
    }

    /**
     * @param value The yearly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("vodmmbtmnahelwoc")
    public suspend fun yearlyRetention(`value`: Output<String>) {
        this.yearlyRetention = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("obwpeewhjjvdeabl")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("qfarrygdrfmaabgu")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The monthly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("cjojicfdplfcwtue")
    public suspend fun monthlyRetention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlyRetention = mapped
    }

    /**
     * @param value The policy name. Should always be Default.
     */
    @JvmName("rchrcqiahevohiqg")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kugbcxncywdmnvkw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The week of year to take the yearly backup in an ISO 8601 format.
     */
    @JvmName("uiltcpenjovilwce")
    public suspend fun weekOfYear(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weekOfYear = mapped
    }

    /**
     * @param value The weekly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("nqabscpjpbesudba")
    public suspend fun weeklyRetention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyRetention = mapped
    }

    /**
     * @param value The yearly retention policy for an LTR backup in an ISO 8601 format.
     */
    @JvmName("rihivjekqwvrjnal")
    public suspend fun yearlyRetention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.yearlyRetention = mapped
    }

    internal fun build(): ManagedInstanceLongTermRetentionPolicyArgs =
        ManagedInstanceLongTermRetentionPolicyArgs(
            databaseName = databaseName,
            managedInstanceName = managedInstanceName,
            monthlyRetention = monthlyRetention,
            policyName = policyName,
            resourceGroupName = resourceGroupName,
            weekOfYear = weekOfYear,
            weeklyRetention = weeklyRetention,
            yearlyRetention = yearlyRetention,
        )
}
