@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedServerDnsAlias].
 */
@PulumiTagMarker
public class ManagedServerDnsAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedServerDnsAliasArgs = ManagedServerDnsAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedServerDnsAliasArgsBuilder.() -> Unit) {
        val builder = ManagedServerDnsAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedServerDnsAlias {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ManagedServerDnsAlias(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedServerDnsAlias(builtJavaResource)
    }
}

/**
 * A managed server DNS alias.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create managed server DNS alias
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedServerDnsAlias = new AzureNative.Sql.ManagedServerDnsAlias("managedServerDnsAlias", new()
 *     {
 *         DnsAliasName = "dns-alias-mi",
 *         ManagedInstanceName = "dns-mi",
 *         ResourceGroupName = "Default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedServerDnsAlias(ctx, "managedServerDnsAlias", &sql.ManagedServerDnsAliasArgs{
 * 			DnsAliasName:        pulumi.String("dns-alias-mi"),
 * 			ManagedInstanceName: pulumi.String("dns-mi"),
 * 			ResourceGroupName:   pulumi.String("Default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedServerDnsAlias;
 * import com.pulumi.azurenative.sql.ManagedServerDnsAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedServerDnsAlias = new ManagedServerDnsAlias("managedServerDnsAlias", ManagedServerDnsAliasArgs.builder()
 *             .dnsAliasName("dns-alias-mi")
 *             .managedInstanceName("dns-mi")
 *             .resourceGroupName("Default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedServerDnsAlias dns-alias-mi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/dnsAliases/{dnsAliasName}
 * ```
 */
public class ManagedServerDnsAlias internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ManagedServerDnsAlias,
) : KotlinCustomResource(javaResource, ManagedServerDnsAliasMapper) {
    /**
     * The fully qualified DNS record for managed server alias
     */
    public val azureDnsRecord: Output<String>
        get() = javaResource.azureDnsRecord().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The fully qualified public DNS record for managed server alias
     */
    public val publicAzureDnsRecord: Output<String>
        get() = javaResource.publicAzureDnsRecord().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedServerDnsAliasMapper : ResourceMapper<ManagedServerDnsAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ManagedServerDnsAlias::class == javaResource::class

    override fun map(javaResource: Resource): ManagedServerDnsAlias =
        ManagedServerDnsAlias(javaResource as com.pulumi.azurenative.sql.ManagedServerDnsAlias)
}

/**
 * @see [ManagedServerDnsAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedServerDnsAlias].
 */
public suspend fun managedServerDnsAlias(
    name: String,
    block: suspend ManagedServerDnsAliasResourceBuilder.() -> Unit,
): ManagedServerDnsAlias {
    val builder = ManagedServerDnsAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedServerDnsAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedServerDnsAlias(name: String): ManagedServerDnsAlias {
    val builder = ManagedServerDnsAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
