@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedServerDnsAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A managed server DNS alias.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create managed server DNS alias
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedServerDnsAlias = new AzureNative.Sql.ManagedServerDnsAlias("managedServerDnsAlias", new()
 *     {
 *         DnsAliasName = "dns-alias-mi",
 *         ManagedInstanceName = "dns-mi",
 *         ResourceGroupName = "Default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedServerDnsAlias(ctx, "managedServerDnsAlias", &sql.ManagedServerDnsAliasArgs{
 * 			DnsAliasName:        pulumi.String("dns-alias-mi"),
 * 			ManagedInstanceName: pulumi.String("dns-mi"),
 * 			ResourceGroupName:   pulumi.String("Default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedServerDnsAlias;
 * import com.pulumi.azurenative.sql.ManagedServerDnsAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedServerDnsAlias = new ManagedServerDnsAlias("managedServerDnsAlias", ManagedServerDnsAliasArgs.builder()
 *             .dnsAliasName("dns-alias-mi")
 *             .managedInstanceName("dns-mi")
 *             .resourceGroupName("Default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedServerDnsAlias dns-alias-mi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/dnsAliases/{dnsAliasName}
 * ```
 * @property createDnsRecord Whether or not DNS record should be created for this alias.
 * @property dnsAliasName
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class ManagedServerDnsAliasArgs(
    public val createDnsRecord: Output<Boolean>? = null,
    public val dnsAliasName: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedServerDnsAliasArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedServerDnsAliasArgs =
        com.pulumi.azurenative.sql.ManagedServerDnsAliasArgs.builder()
            .createDnsRecord(createDnsRecord?.applyValue({ args0 -> args0 }))
            .dnsAliasName(dnsAliasName?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedServerDnsAliasArgs].
 */
@PulumiTagMarker
public class ManagedServerDnsAliasArgsBuilder internal constructor() {
    private var createDnsRecord: Output<Boolean>? = null

    private var dnsAliasName: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Whether or not DNS record should be created for this alias.
     */
    @JvmName("iyjiftxxfhqfrjop")
    public suspend fun createDnsRecord(`value`: Output<Boolean>) {
        this.createDnsRecord = value
    }

    /**
     * @param value
     */
    @JvmName("hrthsfxoihiyhuha")
    public suspend fun dnsAliasName(`value`: Output<String>) {
        this.dnsAliasName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("mpnnagykqvrtcvee")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dtxjdmiovooxcjxi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Whether or not DNS record should be created for this alias.
     */
    @JvmName("bypobrcjuvjsjira")
    public suspend fun createDnsRecord(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createDnsRecord = mapped
    }

    /**
     * @param value
     */
    @JvmName("pfrfkorbnpbmyfrb")
    public suspend fun dnsAliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsAliasName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("gdrbeycligaehtow")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("acelalnesgaorhhu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagedServerDnsAliasArgs = ManagedServerDnsAliasArgs(
        createDnsRecord = createDnsRecord,
        dnsAliasName = dnsAliasName,
        managedInstanceName = managedInstanceName,
        resourceGroupName = resourceGroupName,
    )
}
