@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerAzureADOnlyAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Active Directory only authentication.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Creates or updates Azure Active Directory only authentication object.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverAzureADOnlyAuthentication = new AzureNative.Sql.ServerAzureADOnlyAuthentication("serverAzureADOnlyAuthentication", new()
 *     {
 *         AuthenticationName = "Default",
 *         AzureADOnlyAuthentication = false,
 *         ResourceGroupName = "sqlcrudtest-4799",
 *         ServerName = "sqlcrudtest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerAzureADOnlyAuthentication(ctx, "serverAzureADOnlyAuthentication", &sql.ServerAzureADOnlyAuthenticationArgs{
 * 			AuthenticationName:        pulumi.String("Default"),
 * 			AzureADOnlyAuthentication: pulumi.Bool(false),
 * 			ResourceGroupName:         pulumi.String("sqlcrudtest-4799"),
 * 			ServerName:                pulumi.String("sqlcrudtest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerAzureADOnlyAuthentication;
 * import com.pulumi.azurenative.sql.ServerAzureADOnlyAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverAzureADOnlyAuthentication = new ServerAzureADOnlyAuthentication("serverAzureADOnlyAuthentication", ServerAzureADOnlyAuthenticationArgs.builder()
 *             .authenticationName("Default")
 *             .azureADOnlyAuthentication(false)
 *             .resourceGroupName("sqlcrudtest-4799")
 *             .serverName("sqlcrudtest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerAzureADOnlyAuthentication Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/azureADOnlyAuthentications/{authenticationName}
 * ```
 * @property authenticationName The name of server azure active directory only authentication.
 * @property azureADOnlyAuthentication Azure Active Directory only Authentication enabled.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class ServerAzureADOnlyAuthenticationArgs(
    public val authenticationName: Output<String>? = null,
    public val azureADOnlyAuthentication: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerAzureADOnlyAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerAzureADOnlyAuthenticationArgs =
        com.pulumi.azurenative.sql.ServerAzureADOnlyAuthenticationArgs.builder()
            .authenticationName(authenticationName?.applyValue({ args0 -> args0 }))
            .azureADOnlyAuthentication(azureADOnlyAuthentication?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerAzureADOnlyAuthenticationArgs].
 */
@PulumiTagMarker
public class ServerAzureADOnlyAuthenticationArgsBuilder internal constructor() {
    private var authenticationName: Output<String>? = null

    private var azureADOnlyAuthentication: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of server azure active directory only authentication.
     */
    @JvmName("deywreftsyfmbdms")
    public suspend fun authenticationName(`value`: Output<String>) {
        this.authenticationName = value
    }

    /**
     * @param value Azure Active Directory only Authentication enabled.
     */
    @JvmName("hylnpuwvqctlvyxh")
    public suspend fun azureADOnlyAuthentication(`value`: Output<Boolean>) {
        this.azureADOnlyAuthentication = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lwdgrdkqcbyeuels")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("joqskkfesdhfupxq")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of server azure active directory only authentication.
     */
    @JvmName("yiottrekpaaujwub")
    public suspend fun authenticationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationName = mapped
    }

    /**
     * @param value Azure Active Directory only Authentication enabled.
     */
    @JvmName("ljnbqyeuafxtvoxd")
    public suspend fun azureADOnlyAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureADOnlyAuthentication = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gticamhngkqwwkyl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ahubxpkvdhjrpnpf")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): ServerAzureADOnlyAuthenticationArgs = ServerAzureADOnlyAuthenticationArgs(
        authenticationName = authenticationName,
        azureADOnlyAuthentication = azureADOnlyAuthentication,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
