@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.SqlVulnerabilityAssessmentsSettingArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.SqlVulnerabilityAssessmentState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A SQL Vulnerability Assessment.
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a SQL Vulnerability Assessment policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVulnerabilityAssessmentsSetting = new AzureNative.Sql.SqlVulnerabilityAssessmentsSetting("sqlVulnerabilityAssessmentsSetting", new()
 *     {
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         ServerName = "vulnerabilityaseessmenttest-6440",
 *         State = AzureNative.Sql.SqlVulnerabilityAssessmentState.Enabled,
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSqlVulnerabilityAssessmentsSetting(ctx, "sqlVulnerabilityAssessmentsSetting", &sql.SqlVulnerabilityAssessmentsSettingArgs{
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			ServerName:                  pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			State:                       sql.SqlVulnerabilityAssessmentStateEnabled,
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SqlVulnerabilityAssessmentsSetting;
 * import com.pulumi.azurenative.sql.SqlVulnerabilityAssessmentsSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVulnerabilityAssessmentsSetting = new SqlVulnerabilityAssessmentsSetting("sqlVulnerabilityAssessmentsSetting", SqlVulnerabilityAssessmentsSettingArgs.builder()
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .serverName("vulnerabilityaseessmenttest-6440")
 *             .state("Enabled")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:SqlVulnerabilityAssessmentsSetting default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}
 * ```
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property state Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
 * @property vulnerabilityAssessmentName The name of the SQL Vulnerability Assessment.
 */
public data class SqlVulnerabilityAssessmentsSettingArgs(
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val state: Output<SqlVulnerabilityAssessmentState>? = null,
    public val vulnerabilityAssessmentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.SqlVulnerabilityAssessmentsSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.SqlVulnerabilityAssessmentsSettingArgs =
        com.pulumi.azurenative.sql.SqlVulnerabilityAssessmentsSettingArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlVulnerabilityAssessmentsSettingArgs].
 */
@PulumiTagMarker
public class SqlVulnerabilityAssessmentsSettingArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var state: Output<SqlVulnerabilityAssessmentState>? = null

    private var vulnerabilityAssessmentName: Output<String>? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vgmmbphxmaghgbni")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("amddmghtlreaasib")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
     */
    @JvmName("jyldohipsnyjkkpl")
    public suspend fun state(`value`: Output<SqlVulnerabilityAssessmentState>) {
        this.state = value
    }

    /**
     * @param value The name of the SQL Vulnerability Assessment.
     */
    @JvmName("ijnobneixmedgowv")
    public suspend fun vulnerabilityAssessmentName(`value`: Output<String>) {
        this.vulnerabilityAssessmentName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ykaaweobnigrvyei")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ybnjypodtfdukdfa")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
     */
    @JvmName("vauvmbufoyxflftw")
    public suspend fun state(`value`: SqlVulnerabilityAssessmentState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The name of the SQL Vulnerability Assessment.
     */
    @JvmName("lhrvolbrtbuklpus")
    public suspend fun vulnerabilityAssessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulnerabilityAssessmentName = mapped
    }

    internal fun build(): SqlVulnerabilityAssessmentsSettingArgs =
        SqlVulnerabilityAssessmentsSettingArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            state = state,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
}
