@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.SyncGroupArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.SyncConflictResolutionPolicy
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.SyncGroupSchemaArgs
import com.pulumi.azurenative.sql.kotlin.inputs.SyncGroupSchemaArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An Azure SQL Database sync group.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a sync group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncGroup = new AzureNative.Sql.SyncGroup("syncGroup", new()
 *     {
 *         ConflictResolutionPolicy = "HubWin",
 *         DatabaseName = "syncgroupcrud-4328",
 *         HubDatabaseUserName = "hubUser",
 *         Interval = -1,
 *         ResourceGroupName = "syncgroupcrud-65440",
 *         ServerName = "syncgroupcrud-8475",
 *         SyncDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328",
 *         SyncGroupName = "syncgroupcrud-3187",
 *         UsePrivateLinkConnection = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncGroup(ctx, "syncGroup", &sql.SyncGroupArgs{
 * 			ConflictResolutionPolicy: pulumi.String("HubWin"),
 * 			DatabaseName:             pulumi.String("syncgroupcrud-4328"),
 * 			HubDatabaseUserName:      pulumi.String("hubUser"),
 * 			Interval:                 -1,
 * 			ResourceGroupName:        pulumi.String("syncgroupcrud-65440"),
 * 			ServerName:               pulumi.String("syncgroupcrud-8475"),
 * 			SyncDatabaseId:           pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
 * 			SyncGroupName:            pulumi.String("syncgroupcrud-3187"),
 * 			UsePrivateLinkConnection: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncGroup;
 * import com.pulumi.azurenative.sql.SyncGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncGroup = new SyncGroup("syncGroup", SyncGroupArgs.builder()
 *             .conflictResolutionPolicy("HubWin")
 *             .databaseName("syncgroupcrud-4328")
 *             .hubDatabaseUserName("hubUser")
 *             .interval("TODO: GenUnaryOpExpression")
 *             .resourceGroupName("syncgroupcrud-65440")
 *             .serverName("syncgroupcrud-8475")
 *             .syncDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328")
 *             .syncGroupName("syncgroupcrud-3187")
 *             .usePrivateLinkConnection(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Update a sync group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncGroup = new AzureNative.Sql.SyncGroup("syncGroup", new()
 *     {
 *         ConflictResolutionPolicy = "HubWin",
 *         DatabaseName = "syncgroupcrud-4328",
 *         HubDatabaseUserName = "hubUser",
 *         Interval = -1,
 *         ResourceGroupName = "syncgroupcrud-65440",
 *         ServerName = "syncgroupcrud-8475",
 *         SyncDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328",
 *         SyncGroupName = "syncgroupcrud-3187",
 *         UsePrivateLinkConnection = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncGroup(ctx, "syncGroup", &sql.SyncGroupArgs{
 * 			ConflictResolutionPolicy: pulumi.String("HubWin"),
 * 			DatabaseName:             pulumi.String("syncgroupcrud-4328"),
 * 			HubDatabaseUserName:      pulumi.String("hubUser"),
 * 			Interval:                 -1,
 * 			ResourceGroupName:        pulumi.String("syncgroupcrud-65440"),
 * 			ServerName:               pulumi.String("syncgroupcrud-8475"),
 * 			SyncDatabaseId:           pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
 * 			SyncGroupName:            pulumi.String("syncgroupcrud-3187"),
 * 			UsePrivateLinkConnection: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncGroup;
 * import com.pulumi.azurenative.sql.SyncGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncGroup = new SyncGroup("syncGroup", SyncGroupArgs.builder()
 *             .conflictResolutionPolicy("HubWin")
 *             .databaseName("syncgroupcrud-4328")
 *             .hubDatabaseUserName("hubUser")
 *             .interval("TODO: GenUnaryOpExpression")
 *             .resourceGroupName("syncgroupcrud-65440")
 *             .serverName("syncgroupcrud-8475")
 *             .syncDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328")
 *             .syncGroupName("syncgroupcrud-3187")
 *             .usePrivateLinkConnection(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:SyncGroup syncgroupcrud-3187 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}
 * ```
 * @property conflictLoggingRetentionInDays Conflict logging retention period.
 * @property conflictResolutionPolicy Conflict resolution policy of the sync group.
 * @property databaseName The name of the database on which the sync group is hosted.
 * @property enableConflictLogging If conflict logging is enabled.
 * @property hubDatabasePassword Password for the sync group hub database credential.
 * @property hubDatabaseUserName User name for the sync group hub database credential.
 * @property interval Sync interval of the sync group.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property schema Sync schema of the sync group.
 * @property serverName The name of the server.
 * @property sku The name and capacity of the SKU.
 * @property syncDatabaseId ARM resource id of the sync database in the sync group.
 * @property syncGroupName The name of the sync group.
 * @property usePrivateLinkConnection If use private link connection is enabled.
 */
public data class SyncGroupArgs(
    public val conflictLoggingRetentionInDays: Output<Int>? = null,
    public val conflictResolutionPolicy: Output<Either<String, SyncConflictResolutionPolicy>>? = null,
    public val databaseName: Output<String>? = null,
    public val enableConflictLogging: Output<Boolean>? = null,
    public val hubDatabasePassword: Output<String>? = null,
    public val hubDatabaseUserName: Output<String>? = null,
    public val interval: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schema: Output<SyncGroupSchemaArgs>? = null,
    public val serverName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val syncDatabaseId: Output<String>? = null,
    public val syncGroupName: Output<String>? = null,
    public val usePrivateLinkConnection: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.SyncGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.SyncGroupArgs =
        com.pulumi.azurenative.sql.SyncGroupArgs.builder()
            .conflictLoggingRetentionInDays(conflictLoggingRetentionInDays?.applyValue({ args0 -> args0 }))
            .conflictResolutionPolicy(
                conflictResolutionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .enableConflictLogging(enableConflictLogging?.applyValue({ args0 -> args0 }))
            .hubDatabasePassword(hubDatabasePassword?.applyValue({ args0 -> args0 }))
            .hubDatabaseUserName(hubDatabaseUserName?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .syncDatabaseId(syncDatabaseId?.applyValue({ args0 -> args0 }))
            .syncGroupName(syncGroupName?.applyValue({ args0 -> args0 }))
            .usePrivateLinkConnection(usePrivateLinkConnection?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyncGroupArgs].
 */
@PulumiTagMarker
public class SyncGroupArgsBuilder internal constructor() {
    private var conflictLoggingRetentionInDays: Output<Int>? = null

    private var conflictResolutionPolicy: Output<Either<String, SyncConflictResolutionPolicy>>? = null

    private var databaseName: Output<String>? = null

    private var enableConflictLogging: Output<Boolean>? = null

    private var hubDatabasePassword: Output<String>? = null

    private var hubDatabaseUserName: Output<String>? = null

    private var interval: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var schema: Output<SyncGroupSchemaArgs>? = null

    private var serverName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var syncDatabaseId: Output<String>? = null

    private var syncGroupName: Output<String>? = null

    private var usePrivateLinkConnection: Output<Boolean>? = null

    /**
     * @param value Conflict logging retention period.
     */
    @JvmName("mdycvurjytcplxsj")
    public suspend fun conflictLoggingRetentionInDays(`value`: Output<Int>) {
        this.conflictLoggingRetentionInDays = value
    }

    /**
     * @param value Conflict resolution policy of the sync group.
     */
    @JvmName("xxdgxfppwbljsglr")
    public suspend
    fun conflictResolutionPolicy(`value`: Output<Either<String, SyncConflictResolutionPolicy>>) {
        this.conflictResolutionPolicy = value
    }

    /**
     * @param value The name of the database on which the sync group is hosted.
     */
    @JvmName("qokhlqobhwivjikn")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value If conflict logging is enabled.
     */
    @JvmName("hqwhfvmbxarhnbqi")
    public suspend fun enableConflictLogging(`value`: Output<Boolean>) {
        this.enableConflictLogging = value
    }

    /**
     * @param value Password for the sync group hub database credential.
     */
    @JvmName("hhwwyrsfovimfuyk")
    public suspend fun hubDatabasePassword(`value`: Output<String>) {
        this.hubDatabasePassword = value
    }

    /**
     * @param value User name for the sync group hub database credential.
     */
    @JvmName("somuuosxpxbayknk")
    public suspend fun hubDatabaseUserName(`value`: Output<String>) {
        this.hubDatabaseUserName = value
    }

    /**
     * @param value Sync interval of the sync group.
     */
    @JvmName("pijlcxhcmsqhvgvk")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nqmkbedysxegmdne")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sync schema of the sync group.
     */
    @JvmName("ypiagwbwhqqvyeqb")
    public suspend fun schema(`value`: Output<SyncGroupSchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("mnpurbtbgrovrwlj")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name and capacity of the SKU.
     */
    @JvmName("qglggkkfoeishmjj")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value ARM resource id of the sync database in the sync group.
     */
    @JvmName("jkisfxhnitkxergt")
    public suspend fun syncDatabaseId(`value`: Output<String>) {
        this.syncDatabaseId = value
    }

    /**
     * @param value The name of the sync group.
     */
    @JvmName("gqrgusqtovkmxqvl")
    public suspend fun syncGroupName(`value`: Output<String>) {
        this.syncGroupName = value
    }

    /**
     * @param value If use private link connection is enabled.
     */
    @JvmName("pdbxmwianhyrkesj")
    public suspend fun usePrivateLinkConnection(`value`: Output<Boolean>) {
        this.usePrivateLinkConnection = value
    }

    /**
     * @param value Conflict logging retention period.
     */
    @JvmName("mflsuedlqgandoxi")
    public suspend fun conflictLoggingRetentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictLoggingRetentionInDays = mapped
    }

    /**
     * @param value Conflict resolution policy of the sync group.
     */
    @JvmName("kqivvkijgglwbthe")
    public suspend
    fun conflictResolutionPolicy(`value`: Either<String, SyncConflictResolutionPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictResolutionPolicy = mapped
    }

    /**
     * @param value Conflict resolution policy of the sync group.
     */
    @JvmName("uohjhcgimnwjepeh")
    public fun conflictResolutionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SyncConflictResolutionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conflictResolutionPolicy = mapped
    }

    /**
     * @param value Conflict resolution policy of the sync group.
     */
    @JvmName("lsmajmpnjipnnnqb")
    public fun conflictResolutionPolicy(`value`: SyncConflictResolutionPolicy) {
        val toBeMapped = Either.ofRight<String, SyncConflictResolutionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conflictResolutionPolicy = mapped
    }

    /**
     * @param value The name of the database on which the sync group is hosted.
     */
    @JvmName("dnyfvjcqfvcfrlsa")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value If conflict logging is enabled.
     */
    @JvmName("xvegfngamrsfqxtv")
    public suspend fun enableConflictLogging(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableConflictLogging = mapped
    }

    /**
     * @param value Password for the sync group hub database credential.
     */
    @JvmName("qytxmcjidlsdynhu")
    public suspend fun hubDatabasePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubDatabasePassword = mapped
    }

    /**
     * @param value User name for the sync group hub database credential.
     */
    @JvmName("mafhjsiqtylkqlve")
    public suspend fun hubDatabaseUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubDatabaseUserName = mapped
    }

    /**
     * @param value Sync interval of the sync group.
     */
    @JvmName("ylsfhccdtgxcxgmg")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dphxftgymvsshaho")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sync schema of the sync group.
     */
    @JvmName("abplivfqysjnuqcb")
    public suspend fun schema(`value`: SyncGroupSchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument Sync schema of the sync group.
     */
    @JvmName("xtrjmjeijwpgjhpi")
    public suspend fun schema(argument: suspend SyncGroupSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = SyncGroupSchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ifbrtbvfefugsfqc")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name and capacity of the SKU.
     */
    @JvmName("abtbfujfdksdvfev")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The name and capacity of the SKU.
     */
    @JvmName("bphdwncalandrpnj")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value ARM resource id of the sync database in the sync group.
     */
    @JvmName("twowdkhjpnepopbo")
    public suspend fun syncDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncDatabaseId = mapped
    }

    /**
     * @param value The name of the sync group.
     */
    @JvmName("sanykbxdnbgehwjm")
    public suspend fun syncGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncGroupName = mapped
    }

    /**
     * @param value If use private link connection is enabled.
     */
    @JvmName("olasvephjjmegqup")
    public suspend fun usePrivateLinkConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePrivateLinkConnection = mapped
    }

    internal fun build(): SyncGroupArgs = SyncGroupArgs(
        conflictLoggingRetentionInDays = conflictLoggingRetentionInDays,
        conflictResolutionPolicy = conflictResolutionPolicy,
        databaseName = databaseName,
        enableConflictLogging = enableConflictLogging,
        hubDatabasePassword = hubDatabasePassword,
        hubDatabaseUserName = hubDatabaseUserName,
        interval = interval,
        resourceGroupName = resourceGroupName,
        schema = schema,
        serverName = serverName,
        sku = sku,
        syncDatabaseId = syncDatabaseId,
        syncGroupName = syncGroupName,
        usePrivateLinkConnection = usePrivateLinkConnection,
    )
}
