@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TransparentDataEncryption].
 */
@PulumiTagMarker
public class TransparentDataEncryptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransparentDataEncryptionArgs = TransparentDataEncryptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransparentDataEncryptionArgsBuilder.() -> Unit) {
        val builder = TransparentDataEncryptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TransparentDataEncryption {
        val builtJavaResource =
            com.pulumi.azurenative.sql.TransparentDataEncryption(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransparentDataEncryption(builtJavaResource)
    }
}

/**
 * A logical database transparent data encryption state.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Update a database's Transparent Data Encryption state with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var transparentDataEncryption = new AzureNative.Sql.TransparentDataEncryption("transparentDataEncryption", new()
 *     {
 *         DatabaseName = "testdb",
 *         ResourceGroupName = "securitytde-42-rg",
 *         ServerName = "securitytde-42",
 *         State = AzureNative.Sql.TransparentDataEncryptionState.Enabled,
 *         TdeName = "current",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewTransparentDataEncryption(ctx, "transparentDataEncryption", &sql.TransparentDataEncryptionArgs{
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			ResourceGroupName: pulumi.String("securitytde-42-rg"),
 * 			ServerName:        pulumi.String("securitytde-42"),
 * 			State:             sql.TransparentDataEncryptionStateEnabled,
 * 			TdeName:           pulumi.String("current"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.TransparentDataEncryption;
 * import com.pulumi.azurenative.sql.TransparentDataEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var transparentDataEncryption = new TransparentDataEncryption("transparentDataEncryption", TransparentDataEncryptionArgs.builder()
 *             .databaseName("testdb")
 *             .resourceGroupName("securitytde-42-rg")
 *             .serverName("securitytde-42")
 *             .state("Enabled")
 *             .tdeName("current")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:TransparentDataEncryption current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{tdeName}
 * ```
 */
public class TransparentDataEncryption internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.TransparentDataEncryption,
) : KotlinCustomResource(javaResource, TransparentDataEncryptionMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the state of the transparent data encryption.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TransparentDataEncryptionMapper : ResourceMapper<TransparentDataEncryption> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.TransparentDataEncryption::class == javaResource::class

    override fun map(javaResource: Resource): TransparentDataEncryption =
        TransparentDataEncryption(
            javaResource as
                com.pulumi.azurenative.sql.TransparentDataEncryption,
        )
}

/**
 * @see [TransparentDataEncryption].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransparentDataEncryption].
 */
public suspend fun transparentDataEncryption(
    name: String,
    block: suspend TransparentDataEncryptionResourceBuilder.() -> Unit,
): TransparentDataEncryption {
    val builder = TransparentDataEncryptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransparentDataEncryption].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transparentDataEncryption(name: String): TransparentDataEncryption {
    val builder = TransparentDataEncryptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
