@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.TransparentDataEncryptionArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.TransparentDataEncryptionState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A logical database transparent data encryption state.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Update a database's Transparent Data Encryption state with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var transparentDataEncryption = new AzureNative.Sql.TransparentDataEncryption("transparentDataEncryption", new()
 *     {
 *         DatabaseName = "testdb",
 *         ResourceGroupName = "securitytde-42-rg",
 *         ServerName = "securitytde-42",
 *         State = AzureNative.Sql.TransparentDataEncryptionState.Enabled,
 *         TdeName = "current",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewTransparentDataEncryption(ctx, "transparentDataEncryption", &sql.TransparentDataEncryptionArgs{
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			ResourceGroupName: pulumi.String("securitytde-42-rg"),
 * 			ServerName:        pulumi.String("securitytde-42"),
 * 			State:             sql.TransparentDataEncryptionStateEnabled,
 * 			TdeName:           pulumi.String("current"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.TransparentDataEncryption;
 * import com.pulumi.azurenative.sql.TransparentDataEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var transparentDataEncryption = new TransparentDataEncryption("transparentDataEncryption", TransparentDataEncryptionArgs.builder()
 *             .databaseName("testdb")
 *             .resourceGroupName("securitytde-42-rg")
 *             .serverName("securitytde-42")
 *             .state("Enabled")
 *             .tdeName("current")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:TransparentDataEncryption current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{tdeName}
 * ```
 * @property databaseName The name of the logical database for which the security alert policy is defined.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property state Specifies the state of the transparent data encryption.
 * @property tdeName The name of the transparent data encryption configuration.
 */
public data class TransparentDataEncryptionArgs(
    public val databaseName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val state: Output<TransparentDataEncryptionState>? = null,
    public val tdeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.TransparentDataEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.TransparentDataEncryptionArgs =
        com.pulumi.azurenative.sql.TransparentDataEncryptionArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tdeName(tdeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransparentDataEncryptionArgs].
 */
@PulumiTagMarker
public class TransparentDataEncryptionArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var state: Output<TransparentDataEncryptionState>? = null

    private var tdeName: Output<String>? = null

    /**
     * @param value The name of the logical database for which the security alert policy is defined.
     */
    @JvmName("rkuhcmcdgaadefwo")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("msbfdvcvuomfqqle")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("fjnxlbtodbrrqgip")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Specifies the state of the transparent data encryption.
     */
    @JvmName("kcfsbmyitnuastle")
    public suspend fun state(`value`: Output<TransparentDataEncryptionState>) {
        this.state = value
    }

    /**
     * @param value The name of the transparent data encryption configuration.
     */
    @JvmName("ljanmjnrvuteeamb")
    public suspend fun tdeName(`value`: Output<String>) {
        this.tdeName = value
    }

    /**
     * @param value The name of the logical database for which the security alert policy is defined.
     */
    @JvmName("hbjcamfygewuxywc")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sxlyrmrttnrwombm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("wwrgvwhifqvchqex")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Specifies the state of the transparent data encryption.
     */
    @JvmName("bqdoknpsybvtisgp")
    public suspend fun state(`value`: TransparentDataEncryptionState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The name of the transparent data encryption configuration.
     */
    @JvmName("oyxsgifrtokenhcx")
    public suspend fun tdeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tdeName = mapped
    }

    internal fun build(): TransparentDataEncryptionArgs = TransparentDataEncryptionArgs(
        databaseName = databaseName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        state = state,
        tdeName = tdeName,
    )
}
