@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VirtualNetworkRule].
 */
@PulumiTagMarker
public class VirtualNetworkRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkRuleArgs = VirtualNetworkRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualNetworkRule {
        val builtJavaResource = com.pulumi.azurenative.sql.VirtualNetworkRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualNetworkRule(builtJavaResource)
    }
}

/**
 * A virtual network rule.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a virtual network rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkRule = new AzureNative.Sql.VirtualNetworkRule("virtualNetworkRule", new()
 *     {
 *         IgnoreMissingVnetServiceEndpoint = false,
 *         ResourceGroupName = "Default",
 *         ServerName = "vnet-test-svr",
 *         VirtualNetworkRuleName = "vnet-firewall-rule",
 *         VirtualNetworkSubnetId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewVirtualNetworkRule(ctx, "virtualNetworkRule", &sql.VirtualNetworkRuleArgs{
 * 			IgnoreMissingVnetServiceEndpoint: pulumi.Bool(false),
 * 			ResourceGroupName:                pulumi.String("Default"),
 * 			ServerName:                       pulumi.String("vnet-test-svr"),
 * 			VirtualNetworkRuleName:           pulumi.String("vnet-firewall-rule"),
 * 			VirtualNetworkSubnetId:           pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.VirtualNetworkRule;
 * import com.pulumi.azurenative.sql.VirtualNetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkRule = new VirtualNetworkRule("virtualNetworkRule", VirtualNetworkRuleArgs.builder()
 *             .ignoreMissingVnetServiceEndpoint(false)
 *             .resourceGroupName("Default")
 *             .serverName("vnet-test-svr")
 *             .virtualNetworkRuleName("vnet-firewall-rule")
 *             .virtualNetworkSubnetId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:VirtualNetworkRule vnet-firewall-rule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}
 * ```
 */
public class VirtualNetworkRule internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.VirtualNetworkRule,
) : KotlinCustomResource(javaResource, VirtualNetworkRuleMapper) {
    /**
     * Create firewall rule before the virtual network has vnet service endpoint enabled.
     */
    public val ignoreMissingVnetServiceEndpoint: Output<Boolean>?
        get() = javaResource.ignoreMissingVnetServiceEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Virtual Network Rule State
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The ARM resource id of the virtual network subnet.
     */
    public val virtualNetworkSubnetId: Output<String>
        get() = javaResource.virtualNetworkSubnetId().applyValue({ args0 -> args0 })
}

public object VirtualNetworkRuleMapper : ResourceMapper<VirtualNetworkRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.VirtualNetworkRule::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetworkRule = VirtualNetworkRule(
        javaResource as
            com.pulumi.azurenative.sql.VirtualNetworkRule,
    )
}

/**
 * @see [VirtualNetworkRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetworkRule].
 */
public suspend fun virtualNetworkRule(
    name: String,
    block: suspend VirtualNetworkRuleResourceBuilder.() -> Unit,
): VirtualNetworkRule {
    val builder = VirtualNetworkRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetworkRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetworkRule(name: String): VirtualNetworkRule {
    val builder = VirtualNetworkRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
