@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkloadGroup].
 */
@PulumiTagMarker
public class WorkloadGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadGroupArgs = WorkloadGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadGroupArgsBuilder.() -> Unit) {
        val builder = WorkloadGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkloadGroup {
        val builtJavaResource = com.pulumi.azurenative.sql.WorkloadGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkloadGroup(builtJavaResource)
    }
}

/**
 * Workload group operations for a data warehouse
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a workload group with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadGroup = new AzureNative.Sql.WorkloadGroup("workloadGroup", new()
 *     {
 *         DatabaseName = "testdb",
 *         Importance = "normal",
 *         MaxResourcePercent = 100,
 *         MaxResourcePercentPerRequest = 3,
 *         MinResourcePercent = 0,
 *         MinResourcePercentPerRequest = 3,
 *         QueryExecutionTimeout = 0,
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         WorkloadGroupName = "smallrc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewWorkloadGroup(ctx, "workloadGroup", &sql.WorkloadGroupArgs{
 * 			DatabaseName:                 pulumi.String("testdb"),
 * 			Importance:                   pulumi.String("normal"),
 * 			MaxResourcePercent:           pulumi.Int(100),
 * 			MaxResourcePercentPerRequest: pulumi.Float64(3),
 * 			MinResourcePercent:           pulumi.Int(0),
 * 			MinResourcePercentPerRequest: pulumi.Float64(3),
 * 			QueryExecutionTimeout:        pulumi.Int(0),
 * 			ResourceGroupName:            pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:                   pulumi.String("testsvr"),
 * 			WorkloadGroupName:            pulumi.String("smallrc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.WorkloadGroup;
 * import com.pulumi.azurenative.sql.WorkloadGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadGroup = new WorkloadGroup("workloadGroup", WorkloadGroupArgs.builder()
 *             .databaseName("testdb")
 *             .importance("normal")
 *             .maxResourcePercent(100)
 *             .maxResourcePercentPerRequest(3)
 *             .minResourcePercent(0)
 *             .minResourcePercentPerRequest(3)
 *             .queryExecutionTimeout(0)
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .workloadGroupName("smallrc")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workload group with the required properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadGroup = new AzureNative.Sql.WorkloadGroup("workloadGroup", new()
 *     {
 *         DatabaseName = "testdb",
 *         MaxResourcePercent = 100,
 *         MinResourcePercent = 0,
 *         MinResourcePercentPerRequest = 3,
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         WorkloadGroupName = "smallrc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewWorkloadGroup(ctx, "workloadGroup", &sql.WorkloadGroupArgs{
 * 			DatabaseName:                 pulumi.String("testdb"),
 * 			MaxResourcePercent:           pulumi.Int(100),
 * 			MinResourcePercent:           pulumi.Int(0),
 * 			MinResourcePercentPerRequest: pulumi.Float64(3),
 * 			ResourceGroupName:            pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:                   pulumi.String("testsvr"),
 * 			WorkloadGroupName:            pulumi.String("smallrc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.WorkloadGroup;
 * import com.pulumi.azurenative.sql.WorkloadGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadGroup = new WorkloadGroup("workloadGroup", WorkloadGroupArgs.builder()
 *             .databaseName("testdb")
 *             .maxResourcePercent(100)
 *             .minResourcePercent(0)
 *             .minResourcePercentPerRequest(3)
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .workloadGroupName("smallrc")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:WorkloadGroup smallrc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/workloadGroups/{workloadGroupName}
 * ```
 */
public class WorkloadGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.WorkloadGroup,
) : KotlinCustomResource(javaResource, WorkloadGroupMapper) {
    /**
     * The workload group importance level.
     */
    public val importance: Output<String>?
        get() = javaResource.importance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The workload group cap percentage resource.
     */
    public val maxResourcePercent: Output<Int>
        get() = javaResource.maxResourcePercent().applyValue({ args0 -> args0 })

    /**
     * The workload group request maximum grant percentage.
     */
    public val maxResourcePercentPerRequest: Output<Double>?
        get() = javaResource.maxResourcePercentPerRequest().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The workload group minimum percentage resource.
     */
    public val minResourcePercent: Output<Int>
        get() = javaResource.minResourcePercent().applyValue({ args0 -> args0 })

    /**
     * The workload group request minimum grant percentage.
     */
    public val minResourcePercentPerRequest: Output<Double>
        get() = javaResource.minResourcePercentPerRequest().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The workload group query execution timeout.
     */
    public val queryExecutionTimeout: Output<Int>?
        get() = javaResource.queryExecutionTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadGroupMapper : ResourceMapper<WorkloadGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.WorkloadGroup::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadGroup = WorkloadGroup(
        javaResource as
            com.pulumi.azurenative.sql.WorkloadGroup,
    )
}

/**
 * @see [WorkloadGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadGroup].
 */
public suspend fun workloadGroup(
    name: String,
    block: suspend WorkloadGroupResourceBuilder.() -> Unit,
): WorkloadGroup {
    val builder = WorkloadGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadGroup(name: String): WorkloadGroup {
    val builder = WorkloadGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
