@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.WorkloadGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workload group operations for a data warehouse
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a workload group with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadGroup = new AzureNative.Sql.WorkloadGroup("workloadGroup", new()
 *     {
 *         DatabaseName = "testdb",
 *         Importance = "normal",
 *         MaxResourcePercent = 100,
 *         MaxResourcePercentPerRequest = 3,
 *         MinResourcePercent = 0,
 *         MinResourcePercentPerRequest = 3,
 *         QueryExecutionTimeout = 0,
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         WorkloadGroupName = "smallrc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewWorkloadGroup(ctx, "workloadGroup", &sql.WorkloadGroupArgs{
 * 			DatabaseName:                 pulumi.String("testdb"),
 * 			Importance:                   pulumi.String("normal"),
 * 			MaxResourcePercent:           pulumi.Int(100),
 * 			MaxResourcePercentPerRequest: pulumi.Float64(3),
 * 			MinResourcePercent:           pulumi.Int(0),
 * 			MinResourcePercentPerRequest: pulumi.Float64(3),
 * 			QueryExecutionTimeout:        pulumi.Int(0),
 * 			ResourceGroupName:            pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:                   pulumi.String("testsvr"),
 * 			WorkloadGroupName:            pulumi.String("smallrc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.WorkloadGroup;
 * import com.pulumi.azurenative.sql.WorkloadGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadGroup = new WorkloadGroup("workloadGroup", WorkloadGroupArgs.builder()
 *             .databaseName("testdb")
 *             .importance("normal")
 *             .maxResourcePercent(100)
 *             .maxResourcePercentPerRequest(3)
 *             .minResourcePercent(0)
 *             .minResourcePercentPerRequest(3)
 *             .queryExecutionTimeout(0)
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .workloadGroupName("smallrc")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workload group with the required properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadGroup = new AzureNative.Sql.WorkloadGroup("workloadGroup", new()
 *     {
 *         DatabaseName = "testdb",
 *         MaxResourcePercent = 100,
 *         MinResourcePercent = 0,
 *         MinResourcePercentPerRequest = 3,
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         WorkloadGroupName = "smallrc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewWorkloadGroup(ctx, "workloadGroup", &sql.WorkloadGroupArgs{
 * 			DatabaseName:                 pulumi.String("testdb"),
 * 			MaxResourcePercent:           pulumi.Int(100),
 * 			MinResourcePercent:           pulumi.Int(0),
 * 			MinResourcePercentPerRequest: pulumi.Float64(3),
 * 			ResourceGroupName:            pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:                   pulumi.String("testsvr"),
 * 			WorkloadGroupName:            pulumi.String("smallrc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.WorkloadGroup;
 * import com.pulumi.azurenative.sql.WorkloadGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadGroup = new WorkloadGroup("workloadGroup", WorkloadGroupArgs.builder()
 *             .databaseName("testdb")
 *             .maxResourcePercent(100)
 *             .minResourcePercent(0)
 *             .minResourcePercentPerRequest(3)
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .workloadGroupName("smallrc")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:WorkloadGroup smallrc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/workloadGroups/{workloadGroupName}
 * ```
 * @property databaseName The name of the database.
 * @property importance The workload group importance level.
 * @property maxResourcePercent The workload group cap percentage resource.
 * @property maxResourcePercentPerRequest The workload group request maximum grant percentage.
 * @property minResourcePercent The workload group minimum percentage resource.
 * @property minResourcePercentPerRequest The workload group request minimum grant percentage.
 * @property queryExecutionTimeout The workload group query execution timeout.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property workloadGroupName The name of the workload group.
 */
public data class WorkloadGroupArgs(
    public val databaseName: Output<String>? = null,
    public val importance: Output<String>? = null,
    public val maxResourcePercent: Output<Int>? = null,
    public val maxResourcePercentPerRequest: Output<Double>? = null,
    public val minResourcePercent: Output<Int>? = null,
    public val minResourcePercentPerRequest: Output<Double>? = null,
    public val queryExecutionTimeout: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val workloadGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.WorkloadGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.WorkloadGroupArgs =
        com.pulumi.azurenative.sql.WorkloadGroupArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .importance(importance?.applyValue({ args0 -> args0 }))
            .maxResourcePercent(maxResourcePercent?.applyValue({ args0 -> args0 }))
            .maxResourcePercentPerRequest(maxResourcePercentPerRequest?.applyValue({ args0 -> args0 }))
            .minResourcePercent(minResourcePercent?.applyValue({ args0 -> args0 }))
            .minResourcePercentPerRequest(minResourcePercentPerRequest?.applyValue({ args0 -> args0 }))
            .queryExecutionTimeout(queryExecutionTimeout?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .workloadGroupName(workloadGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadGroupArgs].
 */
@PulumiTagMarker
public class WorkloadGroupArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var importance: Output<String>? = null

    private var maxResourcePercent: Output<Int>? = null

    private var maxResourcePercentPerRequest: Output<Double>? = null

    private var minResourcePercent: Output<Int>? = null

    private var minResourcePercentPerRequest: Output<Double>? = null

    private var queryExecutionTimeout: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var workloadGroupName: Output<String>? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("dxoyqwifqyhlatnq")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The workload group importance level.
     */
    @JvmName("kauxeumipbuhvpus")
    public suspend fun importance(`value`: Output<String>) {
        this.importance = value
    }

    /**
     * @param value The workload group cap percentage resource.
     */
    @JvmName("yahncjuruitnevtm")
    public suspend fun maxResourcePercent(`value`: Output<Int>) {
        this.maxResourcePercent = value
    }

    /**
     * @param value The workload group request maximum grant percentage.
     */
    @JvmName("ujenynwbmjbyefue")
    public suspend fun maxResourcePercentPerRequest(`value`: Output<Double>) {
        this.maxResourcePercentPerRequest = value
    }

    /**
     * @param value The workload group minimum percentage resource.
     */
    @JvmName("lcwpbrubsagroicq")
    public suspend fun minResourcePercent(`value`: Output<Int>) {
        this.minResourcePercent = value
    }

    /**
     * @param value The workload group request minimum grant percentage.
     */
    @JvmName("lhismglordnkdgyo")
    public suspend fun minResourcePercentPerRequest(`value`: Output<Double>) {
        this.minResourcePercentPerRequest = value
    }

    /**
     * @param value The workload group query execution timeout.
     */
    @JvmName("qafwohvitpcpfebe")
    public suspend fun queryExecutionTimeout(`value`: Output<Int>) {
        this.queryExecutionTimeout = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("wtdbagjbljvtplis")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("btccxrfbnavjbqtm")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the workload group.
     */
    @JvmName("kcooiavsrhhptags")
    public suspend fun workloadGroupName(`value`: Output<String>) {
        this.workloadGroupName = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("xpkwdfywxmpkrnte")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The workload group importance level.
     */
    @JvmName("vwtijxagwjfokjev")
    public suspend fun importance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importance = mapped
    }

    /**
     * @param value The workload group cap percentage resource.
     */
    @JvmName("bmqvvlwpbkyllwkn")
    public suspend fun maxResourcePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxResourcePercent = mapped
    }

    /**
     * @param value The workload group request maximum grant percentage.
     */
    @JvmName("tpvlkanqtexhiodr")
    public suspend fun maxResourcePercentPerRequest(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxResourcePercentPerRequest = mapped
    }

    /**
     * @param value The workload group minimum percentage resource.
     */
    @JvmName("smtjebfoneroxkmf")
    public suspend fun minResourcePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minResourcePercent = mapped
    }

    /**
     * @param value The workload group request minimum grant percentage.
     */
    @JvmName("ftnlrimvukxenfec")
    public suspend fun minResourcePercentPerRequest(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minResourcePercentPerRequest = mapped
    }

    /**
     * @param value The workload group query execution timeout.
     */
    @JvmName("nhvmxtfwpqbirvrv")
    public suspend fun queryExecutionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryExecutionTimeout = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rsveiuevsgvdhmri")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("egpitbwsyujuwabo")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name of the workload group.
     */
    @JvmName("hfbfuudjofymjjgo")
    public suspend fun workloadGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadGroupName = mapped
    }

    internal fun build(): WorkloadGroupArgs = WorkloadGroupArgs(
        databaseName = databaseName,
        importance = importance,
        maxResourcePercent = maxResourcePercent,
        maxResourcePercentPerRequest = maxResourcePercentPerRequest,
        minResourcePercent = minResourcePercent,
        minResourcePercentPerRequest = minResourcePercentPerRequest,
        queryExecutionTimeout = queryExecutionTimeout,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        workloadGroupName = workloadGroupName,
    )
}
