@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup (longTermRetentionBackupResourceId required).
 */
public enum class ManagedDatabaseCreateMode(
    public val javaValue: com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode> {
    Default(com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode.Default),
    RestoreExternalBackup(com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode.RestoreExternalBackup),
    PointInTimeRestore(com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode.PointInTimeRestore),
    Recovery(com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode.Recovery),
    RestoreLongTermRetentionBackup(com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode.RestoreLongTermRetentionBackup),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.ManagedDatabaseCreateMode):
            ManagedDatabaseCreateMode =
            ManagedDatabaseCreateMode.values().first { it.javaValue == javaType }
    }
}
