@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
 */
public enum class ManagedInstanceLicenseType(
    public val javaValue: com.pulumi.azurenative.sql.enums.ManagedInstanceLicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.ManagedInstanceLicenseType> {
    LicenseIncluded(com.pulumi.azurenative.sql.enums.ManagedInstanceLicenseType.LicenseIncluded),
    BasePrice(com.pulumi.azurenative.sql.enums.ManagedInstanceLicenseType.BasePrice),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.ManagedInstanceLicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.ManagedInstanceLicenseType):
            ManagedInstanceLicenseType =
            ManagedInstanceLicenseType.values().first { it.javaValue == javaType }
    }
}
