@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
 * @property result The rule baseline result
 */
public data class DatabaseVulnerabilityAssessmentRuleBaselineItemArgs(
    public val result: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs =
        com.pulumi.azurenative.sql.inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs.builder()
            .result(result.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DatabaseVulnerabilityAssessmentRuleBaselineItemArgs].
 */
@PulumiTagMarker
public class DatabaseVulnerabilityAssessmentRuleBaselineItemArgsBuilder internal constructor() {
    private var result: Output<List<String>>? = null

    /**
     * @param value The rule baseline result
     */
    @JvmName("hmlibaklgintjldd")
    public suspend fun result(`value`: Output<List<String>>) {
        this.result = value
    }

    @JvmName("yngnsuihdsujgiep")
    public suspend fun result(vararg values: Output<String>) {
        this.result = Output.all(values.asList())
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("jeputuogpaqbegmv")
    public suspend fun result(values: List<Output<String>>) {
        this.result = Output.all(values)
    }

    /**
     * @param value The rule baseline result
     */
    @JvmName("lornhycyiblbpdcw")
    public suspend fun result(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.result = mapped
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("ysiehjluoxeuphbm")
    public suspend fun result(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.result = mapped
    }

    internal fun build(): DatabaseVulnerabilityAssessmentRuleBaselineItemArgs =
        DatabaseVulnerabilityAssessmentRuleBaselineItemArgs(
            result = result ?: throw PulumiNullFieldException("result"),
        )
}
