@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ElasticPoolPerDatabaseSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Per database settings of an elastic pool.
 * @property maxCapacity The maximum capacity any one database can consume.
 * @property minCapacity The minimum capacity all databases are guaranteed.
 */
public data class ElasticPoolPerDatabaseSettingsArgs(
    public val maxCapacity: Output<Double>? = null,
    public val minCapacity: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ElasticPoolPerDatabaseSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.ElasticPoolPerDatabaseSettingsArgs =
        com.pulumi.azurenative.sql.inputs.ElasticPoolPerDatabaseSettingsArgs.builder()
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ElasticPoolPerDatabaseSettingsArgs].
 */
@PulumiTagMarker
public class ElasticPoolPerDatabaseSettingsArgsBuilder internal constructor() {
    private var maxCapacity: Output<Double>? = null

    private var minCapacity: Output<Double>? = null

    /**
     * @param value The maximum capacity any one database can consume.
     */
    @JvmName("skpdiqjhhdiqmaaf")
    public suspend fun maxCapacity(`value`: Output<Double>) {
        this.maxCapacity = value
    }

    /**
     * @param value The minimum capacity all databases are guaranteed.
     */
    @JvmName("wckurlgrpcuieups")
    public suspend fun minCapacity(`value`: Output<Double>) {
        this.minCapacity = value
    }

    /**
     * @param value The maximum capacity any one database can consume.
     */
    @JvmName("cavrdwwxrhcsuaxh")
    public suspend fun maxCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value The minimum capacity all databases are guaranteed.
     */
    @JvmName("mqnncgwdatchmlou")
    public suspend fun minCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): ElasticPoolPerDatabaseSettingsArgs = ElasticPoolPerDatabaseSettingsArgs(
        maxCapacity = maxCapacity,
        minCapacity = minCapacity,
    )
}
