@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.FailoverGroupReadOnlyEndpointArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ReadOnlyEndpointFailoverPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Read-only endpoint of the failover group instance.
 * @property failoverPolicy Failover policy of the read-only endpoint for the failover group.
 */
public data class FailoverGroupReadOnlyEndpointArgs(
    public val failoverPolicy: Output<Either<String, ReadOnlyEndpointFailoverPolicy>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.FailoverGroupReadOnlyEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.FailoverGroupReadOnlyEndpointArgs =
        com.pulumi.azurenative.sql.inputs.FailoverGroupReadOnlyEndpointArgs.builder()
            .failoverPolicy(
                failoverPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FailoverGroupReadOnlyEndpointArgs].
 */
@PulumiTagMarker
public class FailoverGroupReadOnlyEndpointArgsBuilder internal constructor() {
    private var failoverPolicy: Output<Either<String, ReadOnlyEndpointFailoverPolicy>>? = null

    /**
     * @param value Failover policy of the read-only endpoint for the failover group.
     */
    @JvmName("xdodxbpibfvsyyrj")
    public suspend
    fun failoverPolicy(`value`: Output<Either<String, ReadOnlyEndpointFailoverPolicy>>) {
        this.failoverPolicy = value
    }

    /**
     * @param value Failover policy of the read-only endpoint for the failover group.
     */
    @JvmName("adkfximqmepwaqmu")
    public suspend fun failoverPolicy(`value`: Either<String, ReadOnlyEndpointFailoverPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverPolicy = mapped
    }

    /**
     * @param value Failover policy of the read-only endpoint for the failover group.
     */
    @JvmName("ncijrahurrslfbyp")
    public fun failoverPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReadOnlyEndpointFailoverPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverPolicy = mapped
    }

    /**
     * @param value Failover policy of the read-only endpoint for the failover group.
     */
    @JvmName("hnnmdiumwkykhowh")
    public fun failoverPolicy(`value`: ReadOnlyEndpointFailoverPolicy) {
        val toBeMapped = Either.ofRight<String, ReadOnlyEndpointFailoverPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverPolicy = mapped
    }

    internal fun build(): FailoverGroupReadOnlyEndpointArgs = FailoverGroupReadOnlyEndpointArgs(
        failoverPolicy = failoverPolicy,
    )
}
