@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetBackupShortTermRetentionPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database.
 * @property policyName The policy name. Should always be "default".
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetBackupShortTermRetentionPolicyPlainArgs(
    public val databaseName: String,
    public val policyName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetBackupShortTermRetentionPolicyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetBackupShortTermRetentionPolicyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetBackupShortTermRetentionPolicyPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .policyName(policyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupShortTermRetentionPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetBackupShortTermRetentionPolicyPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var policyName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("qltxfxnymbqajemp")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The policy name. Should always be "default".
     */
    @JvmName("wqcjpmmsykddwnqn")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("seprtastbbvdlfsk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ciutrdmfqqbwikvy")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetBackupShortTermRetentionPolicyPlainArgs =
        GetBackupShortTermRetentionPolicyPlainArgs(
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            policyName = policyName ?: throw PulumiNullFieldException("policyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        )
}
