@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetDataMaskingPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataMaskingPolicyName The name of the database for which the data masking policy applies.
 * @property databaseName The name of the database.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetDataMaskingPolicyPlainArgs(
    public val dataMaskingPolicyName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetDataMaskingPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetDataMaskingPolicyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetDataMaskingPolicyPlainArgs.builder()
            .dataMaskingPolicyName(dataMaskingPolicyName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataMaskingPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetDataMaskingPolicyPlainArgsBuilder internal constructor() {
    private var dataMaskingPolicyName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the database for which the data masking policy applies.
     */
    @JvmName("scoxfeumxrpjtpnm")
    public suspend fun dataMaskingPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataMaskingPolicyName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("kxmvacsyhiddedak")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hxnmrjwwawjlavuf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("jquaiqdnhsrimoht")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetDataMaskingPolicyPlainArgs = GetDataMaskingPolicyPlainArgs(
        dataMaskingPolicyName = dataMaskingPolicyName ?: throw
            PulumiNullFieldException("dataMaskingPolicyName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
