@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetDatabaseThreatDetectionPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database for which database Threat Detection policy is defined.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property securityAlertPolicyName The name of the security alert policy.
 * @property serverName The name of the server.
 */
public data class GetDatabaseThreatDetectionPolicyPlainArgs(
    public val databaseName: String,
    public val resourceGroupName: String,
    public val securityAlertPolicyName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetDatabaseThreatDetectionPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetDatabaseThreatDetectionPolicyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetDatabaseThreatDetectionPolicyPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityAlertPolicyName(securityAlertPolicyName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabaseThreatDetectionPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetDatabaseThreatDetectionPolicyPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var securityAlertPolicyName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the database for which database Threat Detection policy is defined.
     */
    @JvmName("kehbysfksxpqulje")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("cjjduypegihnuriw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the security alert policy.
     */
    @JvmName("leuecorcensdxhcn")
    public suspend fun securityAlertPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityAlertPolicyName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("kjbfqmdanjvfjdrk")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetDatabaseThreatDetectionPolicyPlainArgs =
        GetDatabaseThreatDetectionPolicyPlainArgs(
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            securityAlertPolicyName = securityAlertPolicyName ?: throw
                PulumiNullFieldException("securityAlertPolicyName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        )
}
