@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetEncryptionProtectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionProtectorName The name of the encryption protector to be retrieved.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetEncryptionProtectorPlainArgs(
    public val encryptionProtectorName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetEncryptionProtectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetEncryptionProtectorPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetEncryptionProtectorPlainArgs.builder()
            .encryptionProtectorName(encryptionProtectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEncryptionProtectorPlainArgs].
 */
@PulumiTagMarker
public class GetEncryptionProtectorPlainArgsBuilder internal constructor() {
    private var encryptionProtectorName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the encryption protector to be retrieved.
     */
    @JvmName("kgtavdtqfmruifsw")
    public suspend fun encryptionProtectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.encryptionProtectorName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("fvmtaltyufkqreya")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("wcibemersbkxcqvs")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetEncryptionProtectorPlainArgs = GetEncryptionProtectorPlainArgs(
        encryptionProtectorName = encryptionProtectorName ?: throw
            PulumiNullFieldException("encryptionProtectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
