@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetInstanceFailoverGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property failoverGroupName The name of the failover group.
 * @property locationName The name of the region where the resource is located.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetInstanceFailoverGroupPlainArgs(
    public val failoverGroupName: String,
    public val locationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetInstanceFailoverGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetInstanceFailoverGroupPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetInstanceFailoverGroupPlainArgs.builder()
            .failoverGroupName(failoverGroupName.let({ args0 -> args0 }))
            .locationName(locationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceFailoverGroupPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceFailoverGroupPlainArgsBuilder internal constructor() {
    private var failoverGroupName: String? = null

    private var locationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the failover group.
     */
    @JvmName("spqfibvbvohpsjun")
    public suspend fun failoverGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.failoverGroupName = mapped
    }

    /**
     * @param value The name of the region where the resource is located.
     */
    @JvmName("iufgqlijbyyofyhc")
    public suspend fun locationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.locationName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kkvmnmkkdremxcas")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInstanceFailoverGroupPlainArgs = GetInstanceFailoverGroupPlainArgs(
        failoverGroupName = failoverGroupName ?: throw PulumiNullFieldException("failoverGroupName"),
        locationName = locationName ?: throw PulumiNullFieldException("locationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
