@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetJobAgentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobAgentName The name of the job agent to be retrieved.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetJobAgentPlainArgs(
    public val jobAgentName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetJobAgentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetJobAgentPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetJobAgentPlainArgs.builder()
            .jobAgentName(jobAgentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobAgentPlainArgs].
 */
@PulumiTagMarker
public class GetJobAgentPlainArgsBuilder internal constructor() {
    private var jobAgentName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the job agent to be retrieved.
     */
    @JvmName("uvbqwlsbiueegroi")
    public suspend fun jobAgentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobAgentName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sqjpgwktsoemntrg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("tvfocgfxaowmedda")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetJobAgentPlainArgs = GetJobAgentPlainArgs(
        jobAgentName = jobAgentName ?: throw PulumiNullFieldException("jobAgentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
