@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetJobTargetGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobAgentName The name of the job agent.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property targetGroupName The name of the target group.
 */
public data class GetJobTargetGroupPlainArgs(
    public val jobAgentName: String,
    public val resourceGroupName: String,
    public val serverName: String,
    public val targetGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetJobTargetGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetJobTargetGroupPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetJobTargetGroupPlainArgs.builder()
            .jobAgentName(jobAgentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .targetGroupName(targetGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobTargetGroupPlainArgs].
 */
@PulumiTagMarker
public class GetJobTargetGroupPlainArgsBuilder internal constructor() {
    private var jobAgentName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var targetGroupName: String? = null

    /**
     * @param value The name of the job agent.
     */
    @JvmName("sdnjxxiqeejyaefi")
    public suspend fun jobAgentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobAgentName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("aifohkximkwmkwlw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("knerfbtbbvbettbl")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the target group.
     */
    @JvmName("xybvjsclpabohebk")
    public suspend fun targetGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetGroupName = mapped
    }

    internal fun build(): GetJobTargetGroupPlainArgs = GetJobTargetGroupPlainArgs(
        jobAgentName = jobAgentName ?: throw PulumiNullFieldException("jobAgentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        targetGroupName = targetGroupName ?: throw PulumiNullFieldException("targetGroupName"),
    )
}
