@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedDatabaseSensitivityLabelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnName The name of the column.
 * @property databaseName The name of the database.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property schemaName The name of the schema.
 * @property sensitivityLabelSource The source of the sensitivity label.
 * @property tableName The name of the table.
 */
public data class GetManagedDatabaseSensitivityLabelPlainArgs(
    public val columnName: String,
    public val databaseName: String,
    public val managedInstanceName: String,
    public val resourceGroupName: String,
    public val schemaName: String,
    public val sensitivityLabelSource: String,
    public val tableName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedDatabaseSensitivityLabelPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetManagedDatabaseSensitivityLabelPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedDatabaseSensitivityLabelPlainArgs.builder()
            .columnName(columnName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaName(schemaName.let({ args0 -> args0 }))
            .sensitivityLabelSource(sensitivityLabelSource.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedDatabaseSensitivityLabelPlainArgs].
 */
@PulumiTagMarker
public class GetManagedDatabaseSensitivityLabelPlainArgsBuilder internal constructor() {
    private var columnName: String? = null

    private var databaseName: String? = null

    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var schemaName: String? = null

    private var sensitivityLabelSource: String? = null

    private var tableName: String? = null

    /**
     * @param value The name of the column.
     */
    @JvmName("yblykjiuujkdhfyg")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.columnName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("iujynbeiowttcjun")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("ptvhqrboqntmdxyt")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tvxiibfysekqgdbg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schema.
     */
    @JvmName("tovpvaregiqshhlc")
    public suspend fun schemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaName = mapped
    }

    /**
     * @param value The source of the sensitivity label.
     */
    @JvmName("vtducigapyggpiay")
    public suspend fun sensitivityLabelSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sensitivityLabelSource = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("gvpbehpyxqixoyfa")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    internal fun build(): GetManagedDatabaseSensitivityLabelPlainArgs =
        GetManagedDatabaseSensitivityLabelPlainArgs(
            columnName = columnName ?: throw PulumiNullFieldException("columnName"),
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            schemaName = schemaName ?: throw PulumiNullFieldException("schemaName"),
            sensitivityLabelSource = sensitivityLabelSource ?: throw
                PulumiNullFieldException("sensitivityLabelSource"),
            tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        )
}
