@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedDatabaseVulnerabilityAssessmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database for which the vulnerability assessment is defined.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 */
public data class GetManagedDatabaseVulnerabilityAssessmentPlainArgs(
    public val databaseName: String,
    public val managedInstanceName: String,
    public val resourceGroupName: String,
    public val vulnerabilityAssessmentName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedDatabaseVulnerabilityAssessmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetManagedDatabaseVulnerabilityAssessmentPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedDatabaseVulnerabilityAssessmentPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedDatabaseVulnerabilityAssessmentPlainArgs].
 */
@PulumiTagMarker
public class GetManagedDatabaseVulnerabilityAssessmentPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var vulnerabilityAssessmentName: String? = null

    /**
     * @param value The name of the database for which the vulnerability assessment is defined.
     */
    @JvmName("rpxwtpdpvuxdxhqg")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("fubeijhmfpohhlse")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gokbqqjreefucoce")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("vvkbnoqsksiakirw")
    public suspend fun vulnerabilityAssessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vulnerabilityAssessmentName = mapped
    }

    internal fun build(): GetManagedDatabaseVulnerabilityAssessmentPlainArgs =
        GetManagedDatabaseVulnerabilityAssessmentPlainArgs(
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vulnerabilityAssessmentName = vulnerabilityAssessmentName ?: throw
                PulumiNullFieldException("vulnerabilityAssessmentName"),
        )
}
