@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedInstanceVulnerabilityAssessmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 */
public data class GetManagedInstanceVulnerabilityAssessmentPlainArgs(
    public val managedInstanceName: String,
    public val resourceGroupName: String,
    public val vulnerabilityAssessmentName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedInstanceVulnerabilityAssessmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetManagedInstanceVulnerabilityAssessmentPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedInstanceVulnerabilityAssessmentPlainArgs.builder()
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedInstanceVulnerabilityAssessmentPlainArgs].
 */
@PulumiTagMarker
public class GetManagedInstanceVulnerabilityAssessmentPlainArgsBuilder internal constructor() {
    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var vulnerabilityAssessmentName: String? = null

    /**
     * @param value The name of the managed instance for which the vulnerability assessment is defined.
     */
    @JvmName("ccmyuyxtthdrcegc")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ottxgeodtkgtpmuk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("siysmtkmibnxdagy")
    public suspend fun vulnerabilityAssessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vulnerabilityAssessmentName = mapped
    }

    internal fun build(): GetManagedInstanceVulnerabilityAssessmentPlainArgs =
        GetManagedInstanceVulnerabilityAssessmentPlainArgs(
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vulnerabilityAssessmentName = vulnerabilityAssessmentName ?: throw
                PulumiNullFieldException("vulnerabilityAssessmentName"),
        )
}
