@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedServerDnsAliasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsAliasName
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetManagedServerDnsAliasPlainArgs(
    public val dnsAliasName: String,
    public val managedInstanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedServerDnsAliasPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetManagedServerDnsAliasPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedServerDnsAliasPlainArgs.builder()
            .dnsAliasName(dnsAliasName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedServerDnsAliasPlainArgs].
 */
@PulumiTagMarker
public class GetManagedServerDnsAliasPlainArgsBuilder internal constructor() {
    private var dnsAliasName: String? = null

    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value
     */
    @JvmName("oyiklgrhdqtwhetu")
    public suspend fun dnsAliasName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsAliasName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("iomuwxwvccvtgdci")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("fwlebkmmsjiytwmb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedServerDnsAliasPlainArgs = GetManagedServerDnsAliasPlainArgs(
        dnsAliasName = dnsAliasName ?: throw PulumiNullFieldException("dnsAliasName"),
        managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
