@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetOutboundFirewallRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property outboundRuleFqdn
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetOutboundFirewallRulePlainArgs(
    public val outboundRuleFqdn: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetOutboundFirewallRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetOutboundFirewallRulePlainArgs =
        com.pulumi.azurenative.sql.inputs.GetOutboundFirewallRulePlainArgs.builder()
            .outboundRuleFqdn(outboundRuleFqdn.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOutboundFirewallRulePlainArgs].
 */
@PulumiTagMarker
public class GetOutboundFirewallRulePlainArgsBuilder internal constructor() {
    private var outboundRuleFqdn: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value
     */
    @JvmName("wtiemrdtbtqcdmlv")
    public suspend fun outboundRuleFqdn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.outboundRuleFqdn = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qnjtbpimtduncrbq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ucrndxkemhhqabvh")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetOutboundFirewallRulePlainArgs = GetOutboundFirewallRulePlainArgs(
        outboundRuleFqdn = outboundRuleFqdn ?: throw PulumiNullFieldException("outboundRuleFqdn"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
