@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetSensitivityLabelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnName The name of the column.
 * @property databaseName The name of the database.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property schemaName The name of the schema.
 * @property sensitivityLabelSource The source of the sensitivity label.
 * @property serverName The name of the server.
 * @property tableName The name of the table.
 */
public data class GetSensitivityLabelPlainArgs(
    public val columnName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
    public val schemaName: String,
    public val sensitivityLabelSource: String,
    public val serverName: String,
    public val tableName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetSensitivityLabelPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetSensitivityLabelPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetSensitivityLabelPlainArgs.builder()
            .columnName(columnName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaName(schemaName.let({ args0 -> args0 }))
            .sensitivityLabelSource(sensitivityLabelSource.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSensitivityLabelPlainArgs].
 */
@PulumiTagMarker
public class GetSensitivityLabelPlainArgsBuilder internal constructor() {
    private var columnName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var schemaName: String? = null

    private var sensitivityLabelSource: String? = null

    private var serverName: String? = null

    private var tableName: String? = null

    /**
     * @param value The name of the column.
     */
    @JvmName("twavbvjrwpqpoltl")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.columnName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("grdoyinetiukcmtc")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tduqbkltajhylagl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schema.
     */
    @JvmName("khxwcpmnpimcbimt")
    public suspend fun schemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaName = mapped
    }

    /**
     * @param value The source of the sensitivity label.
     */
    @JvmName("mrptylddpdgussrg")
    public suspend fun sensitivityLabelSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sensitivityLabelSource = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ljhqtmlnqokwyiwb")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("tibqhmiktfcqrqbd")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    internal fun build(): GetSensitivityLabelPlainArgs = GetSensitivityLabelPlainArgs(
        columnName = columnName ?: throw PulumiNullFieldException("columnName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        schemaName = schemaName ?: throw PulumiNullFieldException("schemaName"),
        sensitivityLabelSource = sensitivityLabelSource ?: throw
            PulumiNullFieldException("sensitivityLabelSource"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
