@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetServerAzureADAdministratorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property administratorName The name of server active directory administrator.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetServerAzureADAdministratorPlainArgs(
    public val administratorName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetServerAzureADAdministratorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetServerAzureADAdministratorPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetServerAzureADAdministratorPlainArgs.builder()
            .administratorName(administratorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerAzureADAdministratorPlainArgs].
 */
@PulumiTagMarker
public class GetServerAzureADAdministratorPlainArgsBuilder internal constructor() {
    private var administratorName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of server active directory administrator.
     */
    @JvmName("uyqacadvsajdrsav")
    public suspend fun administratorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.administratorName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("atscwuwmdkfqtsyr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("xowsjhewqhvpyyux")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetServerAzureADAdministratorPlainArgs =
        GetServerAzureADAdministratorPlainArgs(
            administratorName = administratorName ?: throw PulumiNullFieldException("administratorName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        )
}
