@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetServerSecurityAlertPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property securityAlertPolicyName The name of the security alert policy.
 * @property serverName The name of the server.
 */
public data class GetServerSecurityAlertPolicyPlainArgs(
    public val resourceGroupName: String,
    public val securityAlertPolicyName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetServerSecurityAlertPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetServerSecurityAlertPolicyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetServerSecurityAlertPolicyPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityAlertPolicyName(securityAlertPolicyName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerSecurityAlertPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetServerSecurityAlertPolicyPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var securityAlertPolicyName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kirosfotyisgfivh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the security alert policy.
     */
    @JvmName("bshexjoawfjxxqaf")
    public suspend fun securityAlertPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityAlertPolicyName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("unayqhxdkcbkdvmo")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetServerSecurityAlertPolicyPlainArgs =
        GetServerSecurityAlertPolicyPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            securityAlertPolicyName = securityAlertPolicyName ?: throw
                PulumiNullFieldException("securityAlertPolicyName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        )
}
