@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetSyncGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database on which the sync group is hosted.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property syncGroupName The name of the sync group.
 */
public data class GetSyncGroupPlainArgs(
    public val databaseName: String,
    public val resourceGroupName: String,
    public val serverName: String,
    public val syncGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetSyncGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetSyncGroupPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetSyncGroupPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .syncGroupName(syncGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSyncGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSyncGroupPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var syncGroupName: String? = null

    /**
     * @param value The name of the database on which the sync group is hosted.
     */
    @JvmName("crfiogicoprkrton")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("whabcataitjnjlqt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("djssjkmspyimgemu")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the sync group.
     */
    @JvmName("baeoqxdynfrorurx")
    public suspend fun syncGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.syncGroupName = mapped
    }

    internal fun build(): GetSyncGroupPlainArgs = GetSyncGroupPlainArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        syncGroupName = syncGroupName ?: throw PulumiNullFieldException("syncGroupName"),
    )
}
