@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.JobScheduleArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.JobScheduleType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Scheduling properties of a job.
 * @property enabled Whether or not the schedule is enabled.
 * @property endTime Schedule end time.
 * @property interval Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
 * @property startTime Schedule start time.
 * @property type Schedule interval type
 */
public data class JobScheduleArgs(
    public val enabled: Output<Boolean>? = null,
    public val endTime: Output<String>? = null,
    public val interval: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val type: Output<JobScheduleType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.JobScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.JobScheduleArgs =
        com.pulumi.azurenative.sql.inputs.JobScheduleArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobScheduleArgs].
 */
@PulumiTagMarker
public class JobScheduleArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var endTime: Output<String>? = null

    private var interval: Output<String>? = null

    private var startTime: Output<String>? = null

    private var type: Output<JobScheduleType>? = null

    /**
     * @param value Whether or not the schedule is enabled.
     */
    @JvmName("yqukmmqhyihlvnud")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Schedule end time.
     */
    @JvmName("ydhiranpgplxyfdj")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
     */
    @JvmName("vmtnwskmhaoudepi")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value Schedule start time.
     */
    @JvmName("kdmmhyefnuwqggjy")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Schedule interval type
     */
    @JvmName("smgltupngqsdruld")
    public suspend fun type(`value`: Output<JobScheduleType>) {
        this.type = value
    }

    /**
     * @param value Whether or not the schedule is enabled.
     */
    @JvmName("idiblphwkjlnxqgu")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Schedule end time.
     */
    @JvmName("cjicsfxfpploluvg")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
     */
    @JvmName("prqbbbwlyhpywjxu")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Schedule start time.
     */
    @JvmName("vmhyiknofysrurgi")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Schedule interval type
     */
    @JvmName("pkrmbgwxyvaqabvy")
    public suspend fun type(`value`: JobScheduleType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JobScheduleArgs = JobScheduleArgs(
        enabled = enabled,
        endTime = endTime,
        interval = interval,
        startTime = startTime,
        type = type,
    )
}
