@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.JobStepExecutionOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The execution options of a job step.
 * @property initialRetryIntervalSeconds Initial delay between retries for job step execution.
 * @property maximumRetryIntervalSeconds The maximum amount of time to wait between retries for job step execution.
 * @property retryAttempts Maximum number of times the job step will be reattempted if the first attempt fails.
 * @property retryIntervalBackoffMultiplier The backoff multiplier for the time between retries.
 * @property timeoutSeconds Execution timeout for the job step.
 */
public data class JobStepExecutionOptionsArgs(
    public val initialRetryIntervalSeconds: Output<Int>? = null,
    public val maximumRetryIntervalSeconds: Output<Int>? = null,
    public val retryAttempts: Output<Int>? = null,
    public val retryIntervalBackoffMultiplier: Output<Double>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.JobStepExecutionOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.JobStepExecutionOptionsArgs =
        com.pulumi.azurenative.sql.inputs.JobStepExecutionOptionsArgs.builder()
            .initialRetryIntervalSeconds(initialRetryIntervalSeconds?.applyValue({ args0 -> args0 }))
            .maximumRetryIntervalSeconds(maximumRetryIntervalSeconds?.applyValue({ args0 -> args0 }))
            .retryAttempts(retryAttempts?.applyValue({ args0 -> args0 }))
            .retryIntervalBackoffMultiplier(retryIntervalBackoffMultiplier?.applyValue({ args0 -> args0 }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobStepExecutionOptionsArgs].
 */
@PulumiTagMarker
public class JobStepExecutionOptionsArgsBuilder internal constructor() {
    private var initialRetryIntervalSeconds: Output<Int>? = null

    private var maximumRetryIntervalSeconds: Output<Int>? = null

    private var retryAttempts: Output<Int>? = null

    private var retryIntervalBackoffMultiplier: Output<Double>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value Initial delay between retries for job step execution.
     */
    @JvmName("euwibvjnqhmaabsf")
    public suspend fun initialRetryIntervalSeconds(`value`: Output<Int>) {
        this.initialRetryIntervalSeconds = value
    }

    /**
     * @param value The maximum amount of time to wait between retries for job step execution.
     */
    @JvmName("tdxjkbdswbaysaem")
    public suspend fun maximumRetryIntervalSeconds(`value`: Output<Int>) {
        this.maximumRetryIntervalSeconds = value
    }

    /**
     * @param value Maximum number of times the job step will be reattempted if the first attempt fails.
     */
    @JvmName("qgeoalgdisxusuhe")
    public suspend fun retryAttempts(`value`: Output<Int>) {
        this.retryAttempts = value
    }

    /**
     * @param value The backoff multiplier for the time between retries.
     */
    @JvmName("dmdptjuvstfhkcwu")
    public suspend fun retryIntervalBackoffMultiplier(`value`: Output<Double>) {
        this.retryIntervalBackoffMultiplier = value
    }

    /**
     * @param value Execution timeout for the job step.
     */
    @JvmName("yuasicreolokiojq")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value Initial delay between retries for job step execution.
     */
    @JvmName("dlvypipayldmegox")
    public suspend fun initialRetryIntervalSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialRetryIntervalSeconds = mapped
    }

    /**
     * @param value The maximum amount of time to wait between retries for job step execution.
     */
    @JvmName("shblfauffiwmkibo")
    public suspend fun maximumRetryIntervalSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRetryIntervalSeconds = mapped
    }

    /**
     * @param value Maximum number of times the job step will be reattempted if the first attempt fails.
     */
    @JvmName("vodydbqkvstwatdc")
    public suspend fun retryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryAttempts = mapped
    }

    /**
     * @param value The backoff multiplier for the time between retries.
     */
    @JvmName("ilstfyujfhqygfli")
    public suspend fun retryIntervalBackoffMultiplier(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryIntervalBackoffMultiplier = mapped
    }

    /**
     * @param value Execution timeout for the job step.
     */
    @JvmName("resxmjlcvlgsmnvy")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): JobStepExecutionOptionsArgs = JobStepExecutionOptionsArgs(
        initialRetryIntervalSeconds = initialRetryIntervalSeconds,
        maximumRetryIntervalSeconds = maximumRetryIntervalSeconds,
        retryAttempts = retryAttempts,
        retryIntervalBackoffMultiplier = retryIntervalBackoffMultiplier,
        timeoutSeconds = timeoutSeconds,
    )
}
