@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.JobStepOutputArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.JobStepOutputType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The output configuration of a job step.
 * @property credential The resource ID of the credential to use to connect to the output destination.
 * @property databaseName The output destination database.
 * @property resourceGroupName The output destination resource group.
 * @property schemaName The output destination schema.
 * @property serverName The output destination server name.
 * @property subscriptionId The output destination subscription id.
 * @property tableName The output destination table.
 * @property type The output destination type.
 */
public data class JobStepOutputArgs(
    public val credential: Output<String>,
    public val databaseName: Output<String>,
    public val resourceGroupName: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val serverName: Output<String>,
    public val subscriptionId: Output<String>? = null,
    public val tableName: Output<String>,
    public val type: Output<Either<String, JobStepOutputType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.JobStepOutputArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.JobStepOutputArgs =
        com.pulumi.azurenative.sql.inputs.JobStepOutputArgs.builder()
            .credential(credential.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 }))
            .serverName(serverName.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobStepOutputArgs].
 */
@PulumiTagMarker
public class JobStepOutputArgsBuilder internal constructor() {
    private var credential: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tableName: Output<String>? = null

    private var type: Output<Either<String, JobStepOutputType>>? = null

    /**
     * @param value The resource ID of the credential to use to connect to the output destination.
     */
    @JvmName("emvplfxyxsuuowqj")
    public suspend fun credential(`value`: Output<String>) {
        this.credential = value
    }

    /**
     * @param value The output destination database.
     */
    @JvmName("hniwehrmbhajtuar")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The output destination resource group.
     */
    @JvmName("ytrqqmpxtrfipsfg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The output destination schema.
     */
    @JvmName("dwjqiidqgxdeqgsr")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value The output destination server name.
     */
    @JvmName("fanjfynqbrigxcpr")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The output destination subscription id.
     */
    @JvmName("qufyplbrvvixcirp")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The output destination table.
     */
    @JvmName("jwybxikigammswaf")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The output destination type.
     */
    @JvmName("rlxmwvjhnwkcfqvd")
    public suspend fun type(`value`: Output<Either<String, JobStepOutputType>>) {
        this.type = value
    }

    /**
     * @param value The resource ID of the credential to use to connect to the output destination.
     */
    @JvmName("fndgwgajtyhpchee")
    public suspend fun credential(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param value The output destination database.
     */
    @JvmName("hdflujoffaetxrtd")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The output destination resource group.
     */
    @JvmName("vaogqxenwjgqxxfo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The output destination schema.
     */
    @JvmName("ftrqwinuieqtbdke")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value The output destination server name.
     */
    @JvmName("vhclhbpcwfqboinf")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The output destination subscription id.
     */
    @JvmName("gowelpwemdlgfcka")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value The output destination table.
     */
    @JvmName("ewfqtboywdjjwkwf")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The output destination type.
     */
    @JvmName("kknqpvboywxpmmtr")
    public suspend fun type(`value`: Either<String, JobStepOutputType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The output destination type.
     */
    @JvmName("baplevdxpamxityv")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JobStepOutputType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The output destination type.
     */
    @JvmName("nhijryvbyidugiyy")
    public fun type(`value`: JobStepOutputType) {
        val toBeMapped = Either.ofRight<String, JobStepOutputType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JobStepOutputArgs = JobStepOutputArgs(
        credential = credential ?: throw PulumiNullFieldException("credential"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName,
        schemaName = schemaName,
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        subscriptionId = subscriptionId,
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        type = type,
    )
}
