@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ManagedInstanceExternalAdministratorArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.AdministratorType
import com.pulumi.azurenative.sql.kotlin.enums.PrincipalType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a active directory administrator.
 * @property administratorType Type of the sever administrator.
 * @property azureADOnlyAuthentication Azure Active Directory only Authentication enabled.
 * @property login Login name of the server administrator.
 * @property principalType Principal Type of the sever administrator.
 * @property sid SID (object ID) of the server administrator.
 * @property tenantId Tenant ID of the administrator.
 */
public data class ManagedInstanceExternalAdministratorArgs(
    public val administratorType: Output<Either<String, AdministratorType>>? = null,
    public val azureADOnlyAuthentication: Output<Boolean>? = null,
    public val login: Output<String>? = null,
    public val principalType: Output<Either<String, PrincipalType>>? = null,
    public val sid: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ManagedInstanceExternalAdministratorArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.ManagedInstanceExternalAdministratorArgs =
        com.pulumi.azurenative.sql.inputs.ManagedInstanceExternalAdministratorArgs.builder()
            .administratorType(
                administratorType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureADOnlyAuthentication(azureADOnlyAuthentication?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0 }))
            .principalType(
                principalType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sid(sid?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstanceExternalAdministratorArgs].
 */
@PulumiTagMarker
public class ManagedInstanceExternalAdministratorArgsBuilder internal constructor() {
    private var administratorType: Output<Either<String, AdministratorType>>? = null

    private var azureADOnlyAuthentication: Output<Boolean>? = null

    private var login: Output<String>? = null

    private var principalType: Output<Either<String, PrincipalType>>? = null

    private var sid: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("ukcqbbealeifplpc")
    public suspend fun administratorType(`value`: Output<Either<String, AdministratorType>>) {
        this.administratorType = value
    }

    /**
     * @param value Azure Active Directory only Authentication enabled.
     */
    @JvmName("iskjebdxockqqiwj")
    public suspend fun azureADOnlyAuthentication(`value`: Output<Boolean>) {
        this.azureADOnlyAuthentication = value
    }

    /**
     * @param value Login name of the server administrator.
     */
    @JvmName("vuqltsvaqruucyjf")
    public suspend fun login(`value`: Output<String>) {
        this.login = value
    }

    /**
     * @param value Principal Type of the sever administrator.
     */
    @JvmName("yfneekbblcpbsvbt")
    public suspend fun principalType(`value`: Output<Either<String, PrincipalType>>) {
        this.principalType = value
    }

    /**
     * @param value SID (object ID) of the server administrator.
     */
    @JvmName("hhtmhfyfhgtqourp")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Tenant ID of the administrator.
     */
    @JvmName("rbdmjtsugejjxnvg")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("xowbiylqifykehox")
    public suspend fun administratorType(`value`: Either<String, AdministratorType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("rujsprgivvcllsea")
    public fun administratorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AdministratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("gaabpladfxujeeuq")
    public fun administratorType(`value`: AdministratorType) {
        val toBeMapped = Either.ofRight<String, AdministratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Azure Active Directory only Authentication enabled.
     */
    @JvmName("piqtsaulvptwymsc")
    public suspend fun azureADOnlyAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureADOnlyAuthentication = mapped
    }

    /**
     * @param value Login name of the server administrator.
     */
    @JvmName("wqgdxjxuodmssvrf")
    public suspend fun login(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param value Principal Type of the sever administrator.
     */
    @JvmName("orqfumjajcgdbilr")
    public suspend fun principalType(`value`: Either<String, PrincipalType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value Principal Type of the sever administrator.
     */
    @JvmName("tlctcbvfhcqyvbok")
    public fun principalType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value Principal Type of the sever administrator.
     */
    @JvmName("vqbkcwhyvbtlfuhf")
    public fun principalType(`value`: PrincipalType) {
        val toBeMapped = Either.ofRight<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value SID (object ID) of the server administrator.
     */
    @JvmName("ninjslncfqnogttk")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Tenant ID of the administrator.
     */
    @JvmName("kndvqsxxibghjkst")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ManagedInstanceExternalAdministratorArgs =
        ManagedInstanceExternalAdministratorArgs(
            administratorType = administratorType,
            azureADOnlyAuthentication = azureADOnlyAuthentication,
            login = login,
            principalType = principalType,
            sid = sid,
            tenantId = tenantId,
        )
}
