@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.PartnerRegionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Partner region information for the failover group.
 * @property location Geo location of the partner managed instances.
 */
public data class PartnerRegionInfoArgs(
    public val location: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.PartnerRegionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.PartnerRegionInfoArgs =
        com.pulumi.azurenative.sql.inputs.PartnerRegionInfoArgs.builder()
            .location(location?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartnerRegionInfoArgs].
 */
@PulumiTagMarker
public class PartnerRegionInfoArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    /**
     * @param value Geo location of the partner managed instances.
     */
    @JvmName("tkfhjsgbgminyqrc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Geo location of the partner managed instances.
     */
    @JvmName("htdrnhnqrkfypbhh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    internal fun build(): PartnerRegionInfoArgs = PartnerRegionInfoArgs(
        location = location,
    )
}
