@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ServicePrincipalArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ServicePrincipalType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The managed instance's service principal configuration for a resource.
 * @property type Service principal type.
 */
public data class ServicePrincipalArgs(
    public val type: Output<Either<String, ServicePrincipalType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ServicePrincipalArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.ServicePrincipalArgs =
        com.pulumi.azurenative.sql.inputs.ServicePrincipalArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServicePrincipalArgs].
 */
@PulumiTagMarker
public class ServicePrincipalArgsBuilder internal constructor() {
    private var type: Output<Either<String, ServicePrincipalType>>? = null

    /**
     * @param value Service principal type.
     */
    @JvmName("rlgmqornsbeqhiae")
    public suspend fun type(`value`: Output<Either<String, ServicePrincipalType>>) {
        this.type = value
    }

    /**
     * @param value Service principal type.
     */
    @JvmName("qwjcqwuhsdntgsse")
    public suspend fun type(`value`: Either<String, ServicePrincipalType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Service principal type.
     */
    @JvmName("giwtwkdgluwhcwbp")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServicePrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Service principal type.
     */
    @JvmName("mkhcvatwjxnontvb")
    public fun type(`value`: ServicePrincipalType) {
        val toBeMapped = Either.ofRight<String, ServicePrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicePrincipalArgs = ServicePrincipalArgs(
        type = type,
    )
}
