@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.SyncGroupSchemaTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of table in sync group schema.
 * @property columns List of columns in sync group schema.
 * @property quotedName Quoted name of sync group schema table.
 */
public data class SyncGroupSchemaTableArgs(
    public val columns: Output<List<SyncGroupSchemaTableColumnArgs>>? = null,
    public val quotedName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.SyncGroupSchemaTableArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.SyncGroupSchemaTableArgs =
        com.pulumi.azurenative.sql.inputs.SyncGroupSchemaTableArgs.builder()
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .quotedName(quotedName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyncGroupSchemaTableArgs].
 */
@PulumiTagMarker
public class SyncGroupSchemaTableArgsBuilder internal constructor() {
    private var columns: Output<List<SyncGroupSchemaTableColumnArgs>>? = null

    private var quotedName: Output<String>? = null

    /**
     * @param value List of columns in sync group schema.
     */
    @JvmName("aoxutlrfpmkhwamq")
    public suspend fun columns(`value`: Output<List<SyncGroupSchemaTableColumnArgs>>) {
        this.columns = value
    }

    @JvmName("wkicxjsakujsviyt")
    public suspend fun columns(vararg values: Output<SyncGroupSchemaTableColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values List of columns in sync group schema.
     */
    @JvmName("vgcxddhanjfsydbh")
    public suspend fun columns(values: List<Output<SyncGroupSchemaTableColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Quoted name of sync group schema table.
     */
    @JvmName("jpnnrnvadyrynwix")
    public suspend fun quotedName(`value`: Output<String>) {
        this.quotedName = value
    }

    /**
     * @param value List of columns in sync group schema.
     */
    @JvmName("wemcxjwofcarkvtt")
    public suspend fun columns(`value`: List<SyncGroupSchemaTableColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument List of columns in sync group schema.
     */
    @JvmName("ioitctusejvyqhxq")
    public suspend
    fun columns(argument: List<suspend SyncGroupSchemaTableColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SyncGroupSchemaTableColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument List of columns in sync group schema.
     */
    @JvmName("morrvqtlnvixkoek")
    public suspend fun columns(
        vararg
        argument: suspend SyncGroupSchemaTableColumnArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SyncGroupSchemaTableColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument List of columns in sync group schema.
     */
    @JvmName("aacnymyilimojmln")
    public suspend fun columns(argument: suspend SyncGroupSchemaTableColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SyncGroupSchemaTableColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values List of columns in sync group schema.
     */
    @JvmName("ccvhnjaiawkegeue")
    public suspend fun columns(vararg values: SyncGroupSchemaTableColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value Quoted name of sync group schema table.
     */
    @JvmName("wktkxjwypjpnxugq")
    public suspend fun quotedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotedName = mapped
    }

    internal fun build(): SyncGroupSchemaTableArgs = SyncGroupSchemaTableArgs(
        columns = columns,
        quotedName = quotedName,
    )
}
