@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.SyncGroupSchemaTableColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of column in sync group table.
 * @property dataSize Data size of the column.
 * @property dataType Data type of the column.
 * @property quotedName Quoted name of sync group table column.
 */
public data class SyncGroupSchemaTableColumnArgs(
    public val dataSize: Output<String>? = null,
    public val dataType: Output<String>? = null,
    public val quotedName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.SyncGroupSchemaTableColumnArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.SyncGroupSchemaTableColumnArgs =
        com.pulumi.azurenative.sql.inputs.SyncGroupSchemaTableColumnArgs.builder()
            .dataSize(dataSize?.applyValue({ args0 -> args0 }))
            .dataType(dataType?.applyValue({ args0 -> args0 }))
            .quotedName(quotedName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyncGroupSchemaTableColumnArgs].
 */
@PulumiTagMarker
public class SyncGroupSchemaTableColumnArgsBuilder internal constructor() {
    private var dataSize: Output<String>? = null

    private var dataType: Output<String>? = null

    private var quotedName: Output<String>? = null

    /**
     * @param value Data size of the column.
     */
    @JvmName("dqtfhtyryjounqdq")
    public suspend fun dataSize(`value`: Output<String>) {
        this.dataSize = value
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("ejtufecxohofsreb")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value Quoted name of sync group table column.
     */
    @JvmName("gvxdqugijtsdpgpe")
    public suspend fun quotedName(`value`: Output<String>) {
        this.quotedName = value
    }

    /**
     * @param value Data size of the column.
     */
    @JvmName("yshdlkkjkmshapwd")
    public suspend fun dataSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSize = mapped
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("iqvuxfsdcjruhxxk")
    public suspend fun dataType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value Quoted name of sync group table column.
     */
    @JvmName("diqtnnjeioimdkqw")
    public suspend fun quotedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotedName = mapped
    }

    internal fun build(): SyncGroupSchemaTableColumnArgs = SyncGroupSchemaTableColumnArgs(
        dataSize = dataSize,
        dataType = dataType,
        quotedName = quotedName,
    )
}
