@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A long term retention policy.
 * @property id Resource ID.
 * @property monthlyRetention The monthly retention policy for an LTR backup in an ISO 8601 format.
 * @property name Resource name.
 * @property type Resource type.
 * @property weekOfYear The week of year to take the yearly backup in an ISO 8601 format.
 * @property weeklyRetention The weekly retention policy for an LTR backup in an ISO 8601 format.
 * @property yearlyRetention The yearly retention policy for an LTR backup in an ISO 8601 format.
 */
public data class GetBackupLongTermRetentionPolicyResult(
    public val id: String,
    public val monthlyRetention: String? = null,
    public val name: String,
    public val type: String,
    public val weekOfYear: Int? = null,
    public val weeklyRetention: String? = null,
    public val yearlyRetention: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetBackupLongTermRetentionPolicyResult):
            GetBackupLongTermRetentionPolicyResult = GetBackupLongTermRetentionPolicyResult(
            id = javaType.id(),
            monthlyRetention = javaType.monthlyRetention().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
            weekOfYear = javaType.weekOfYear().map({ args0 -> args0 }).orElse(null),
            weeklyRetention = javaType.weeklyRetention().map({ args0 -> args0 }).orElse(null),
            yearlyRetention = javaType.yearlyRetention().map({ args0 -> args0 }).orElse(null),
        )
    }
}
