@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a disaster recovery configuration.
 * @property autoFailover Whether or not failover can be done automatically.
 * @property failoverPolicy How aggressive the automatic failover should be.
 * @property id Resource ID.
 * @property location Location of the server that contains this disaster recovery configuration.
 * @property logicalServerName Logical name of the server.
 * @property name Resource name.
 * @property partnerLogicalServerName Logical name of the partner server.
 * @property partnerServerId Id of the partner server.
 * @property role The role of the current server in the disaster recovery configuration.
 * @property status The status of the disaster recovery configuration.
 * @property type Resource type.
 */
public data class GetDisasterRecoveryConfigurationResult(
    public val autoFailover: String,
    public val failoverPolicy: String,
    public val id: String,
    public val location: String,
    public val logicalServerName: String,
    public val name: String,
    public val partnerLogicalServerName: String,
    public val partnerServerId: String,
    public val role: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetDisasterRecoveryConfigurationResult):
            GetDisasterRecoveryConfigurationResult = GetDisasterRecoveryConfigurationResult(
            autoFailover = javaType.autoFailover(),
            failoverPolicy = javaType.failoverPolicy(),
            id = javaType.id(),
            location = javaType.location(),
            logicalServerName = javaType.logicalServerName(),
            name = javaType.name(),
            partnerLogicalServerName = javaType.partnerLogicalServerName(),
            partnerServerId = javaType.partnerServerId(),
            role = javaType.role(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
