@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An instance failover group.
 * @property id Resource ID.
 * @property managedInstancePairs List of managed instance pairs in the failover group.
 * @property name Resource name.
 * @property partnerRegions Partner region information for the failover group.
 * @property readOnlyEndpoint Read-only endpoint of the failover group instance.
 * @property readWriteEndpoint Read-write endpoint of the failover group instance.
 * @property replicationRole Local replication role of the failover group instance.
 * @property replicationState Replication state of the failover group instance.
 * @property type Resource type.
 */
public data class GetInstanceFailoverGroupResult(
    public val id: String,
    public val managedInstancePairs: List<ManagedInstancePairInfoResponse>,
    public val name: String,
    public val partnerRegions: List<PartnerRegionInfoResponse>,
    public val readOnlyEndpoint: InstanceFailoverGroupReadOnlyEndpointResponse? = null,
    public val readWriteEndpoint: InstanceFailoverGroupReadWriteEndpointResponse,
    public val replicationRole: String,
    public val replicationState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetInstanceFailoverGroupResult):
            GetInstanceFailoverGroupResult = GetInstanceFailoverGroupResult(
            id = javaType.id(),
            managedInstancePairs = javaType.managedInstancePairs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePairInfoResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            partnerRegions = javaType.partnerRegions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.PartnerRegionInfoResponse.Companion.toKotlin(args0)
                })
            }),
            readOnlyEndpoint = javaType.readOnlyEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.InstanceFailoverGroupReadOnlyEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readWriteEndpoint = javaType.readWriteEndpoint().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.InstanceFailoverGroupReadWriteEndpointResponse.Companion.toKotlin(args0)
            }),
            replicationRole = javaType.replicationRole(),
            replicationState = javaType.replicationState(),
            type = javaType.type(),
        )
    }
}
