@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A job.
 * @property description User-defined description of the job.
 * @property id Resource ID.
 * @property name Resource name.
 * @property schedule Schedule properties of the job.
 * @property type Resource type.
 * @property version The job version number.
 */
public data class GetJobResult(
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val schedule: JobScheduleResponse? = null,
    public val type: String,
    public val version: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetJobResult): GetJobResult =
            GetJobResult(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                name = javaType.name(),
                schedule = javaType.schedule().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sql.kotlin.outputs.JobScheduleResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
                version = javaType.version(),
            )
    }
}
