@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A job step.
 * @property action The action payload of the job step.
 * @property credential The resource ID of the job credential that will be used to connect to the targets.
 * @property executionOptions Execution options for the job step.
 * @property id Resource ID.
 * @property name Resource name.
 * @property output Output destination properties of the job step.
 * @property stepId The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
 * @property targetGroup The resource ID of the target group that the job step will be executed on.
 * @property type Resource type.
 */
public data class GetJobStepResult(
    public val action: JobStepActionResponse,
    public val credential: String,
    public val executionOptions: JobStepExecutionOptionsResponse? = null,
    public val id: String,
    public val name: String,
    public val output: JobStepOutputResponse? = null,
    public val stepId: Int? = null,
    public val targetGroup: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetJobStepResult):
            GetJobStepResult = GetJobStepResult(
            action = javaType.action().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.JobStepActionResponse.Companion.toKotlin(args0)
            }),
            credential = javaType.credential(),
            executionOptions = javaType.executionOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.JobStepExecutionOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            output = javaType.output().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.JobStepOutputResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            stepId = javaType.stepId().map({ args0 -> args0 }).orElse(null),
            targetGroup = javaType.targetGroup(),
            type = javaType.type(),
        )
    }
}
