@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Azure SQL DB Server Outbound Firewall Rule.
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The state of the outbound rule.
 * @property type Resource type.
 */
public data class GetOutboundFirewallRuleResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetOutboundFirewallRuleResult):
            GetOutboundFirewallRuleResult = GetOutboundFirewallRuleResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
