@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An Azure SQL Database sync member.
 * @property databaseName Database name of the member database in the sync member.
 * @property databaseType Database type of the sync member.
 * @property id Resource ID.
 * @property name Resource name.
 * @property privateEndpointName Private endpoint name of the sync member if use private link connection is enabled, for sync members in Azure.
 * @property serverName Server name of the member database in the sync member
 * @property sqlServerDatabaseId SQL Server database id of the sync member.
 * @property syncAgentId ARM resource id of the sync agent in the sync member.
 * @property syncDirection Sync direction of the sync member.
 * @property syncMemberAzureDatabaseResourceId ARM resource id of the sync member logical database, for sync members in Azure.
 * @property syncState Sync state of the sync member.
 * @property type Resource type.
 * @property usePrivateLinkConnection Whether to use private link connection.
 * @property userName User name of the member database in the sync member.
 */
public data class GetSyncMemberResult(
    public val databaseName: String? = null,
    public val databaseType: String? = null,
    public val id: String,
    public val name: String,
    public val privateEndpointName: String,
    public val serverName: String? = null,
    public val sqlServerDatabaseId: String? = null,
    public val syncAgentId: String? = null,
    public val syncDirection: String? = null,
    public val syncMemberAzureDatabaseResourceId: String? = null,
    public val syncState: String,
    public val type: String,
    public val usePrivateLinkConnection: Boolean? = null,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetSyncMemberResult):
            GetSyncMemberResult = GetSyncMemberResult(
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            databaseType = javaType.databaseType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            privateEndpointName = javaType.privateEndpointName(),
            serverName = javaType.serverName().map({ args0 -> args0 }).orElse(null),
            sqlServerDatabaseId = javaType.sqlServerDatabaseId().map({ args0 -> args0 }).orElse(null),
            syncAgentId = javaType.syncAgentId().map({ args0 -> args0 }).orElse(null),
            syncDirection = javaType.syncDirection().map({ args0 -> args0 }).orElse(null),
            syncMemberAzureDatabaseResourceId = javaType.syncMemberAzureDatabaseResourceId().map({ args0 ->
                args0
            }).orElse(null),
            syncState = javaType.syncState(),
            type = javaType.type(),
            usePrivateLinkConnection = javaType.usePrivateLinkConnection().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
